#!/usr/bin/python 
# 

# Copyright: (c) 2018, Jesse Keating <jesse.keating@example.org>
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

ANSIBLE_METADATA = {'metadata_version': '1.1',
                    'status': ['preview'],
                    'supported_by': 'community'}

DOCUMENTATION = ''' 
---
module: remote_filecopy
version_added: "2.9"
short_description: Kopiuje plik do zdalnego hosta
description:
  - Moduł remote_copy kopiuje plik w zdalnym hoście, z podanej lokalizacji źródłowej do podanej lokalizacji docelowej.
options:
  source:
    description:
      - To jest ścieżka dostępu do pliku źródłowego w zdalnym hoście
    required: True
  dest:
    description:
      - To jest ścieżka dostępu do pliku docelowego w zdalnym hoście
    required: True
author:
- Jesse Keating (@omgjlk)
''' 
EXAMPLES = '''
   # Przykład pochodzący ze scenariusza Ansible
   - name: utworzenie kopii zapasowej pliku konfiguracyjnego
     remote_copy:
       source: /etc/herp/derp.conf
       dest: /root/herp-derp.conf.bak
'''
RETURN = '''
source:
  description: plik źródłowy używany podczas operacji kopiowania
  returned: success
  type: str
  sample: "/ścieżka/dostępu/do/nazwy.pliku"
dest:
  description: plik docelowy używany podczas operacji kopiowania
  returned: success
  type: str
  sample: "/ścieżka/dostępu/do/nazwy.pliku.docelowego"
gid:
  description: identyfikator grupy docelowej
  returned: success
  type: int
  sample: 502
group:
  description: nazwa grupy docelowej
  returned: success
  type: str
  sample: "users"
uid:
  description: identyfikator właściciela docelowego
  returned: success
  type: int
  sample: 502
owner:
  description: nazwa grupy docelowej
  returned: success
  type: str
  sample: "fred"
mode:
  description: uprawnienia docelowe
  returned: success
  type: int
  sample: 0644
size:
  description: docelowa wielkość pliku
  returned: success
  type: int
  sample: 20
state:
  description: stan elementu docelowego
  returned: success
  type: str
  sample: "file"
'''

import shutil 

def main(): 
    module = AnsibleModule( 
        argument_spec = dict( 
            source=dict(required=True, type='str'), 
            dest=dict(required=True, type='str') 
        ), 
    ) 
    shutil.copy(module.params['source'], 
                module.params['dest']) 
 
    module.exit_json(changed=True) 

from ansible.module_utils.basic import * 
if __name__ == '__main__': 
    main() 
