import {Server} from "ws";

var wsServer = new Server({port:8085});

console.log('Serwer WebSocket nasłuchuje na porcie 8085');

wsServer.on('connection',
    websocket => {

        websocket.send('Pozdrowienia od dwukierunkowego serwera WebSocket');

        websocket.onmessage = (message) =>
                console.log(`Serwer otrzymał:  ${message['data']}`);

        websocket.onerror = (error) =>
            console.log(`Serwer otrzymał: ${error['code']}`);

        websocket.onclose = (why) =>
            console.log(`Serwer otrzymał: ${why.code} ${why.reason}`);
    }
);







// Broadcasting to all clients
/*
wsServer.on('connection',
    websocket => wsServer.clients
        .forEach(
            client =>client.send('This message was pushed by the WebSocket server')));*/
