import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'temperature'
})
export class TemperaturePipe implements PipeTransform {

  transform(value: any, fromTo: string): any {
    if (!fromTo) {
      throw new Error('Potok temperatury wymaga parameteru FnaC lub CnaF');
    }

    return (
      fromTo == 'FnaC'
        ? (value - 32) * 5 / 9  // F na C
        : value * 9 / 5 + 32    // C na F
    );
  }
}
