import { Component } from '@angular/core';

@Component({
  selector: 'app-root',
  template: `
    <form #f="ngForm" (ngSubmit)="onSubmit(f.value)" >
      <div>
        Numer telefonu:
        <input type="text" name="telephone" ngModel
               required
               pattern="[0-9]*"
               minlength="10"
               #phone="ngModel"
               [class.hasError]="phone.invalid && phone.touched">
        <div [hidden]="phone.valid || phone.pristine">
          <div class="error" [hidden]="!phone.hasError('minlength')">Numer telefonu musi mieć co najmniej 10 cyfr</div>
          <div class="error" [hidden]="!phone.hasError('required')">Numer telefonu jest wymagany</div>
          <div class="error" [hidden]="!phone.hasError('pattern')">Dopuszczalne są tylko cyfry</div>
        </div>

      </div>
      <button type="submit"
              [disabled]="f.invalid">Wyślij</button>
    </form>
  `,
  styles: ['.error {color: red;} .hasError {border: 1px solid red;}']
})
export class AppComponent {
  onSubmit(formData) {
    console.log(formData);
  }
}
