import { Component } from '@angular/core';
import { FormControl} from '@angular/forms';
import { debounceTime } from 'rxjs/operators';

@Component({
  selector: "app-root",
  template: `
       <h2>Zdarzenia obserwowalne z formcontrol</h2>
      <input type="text" placeholder="Wpisz symbol spółki" [formControl]="searchInput">
    `
})
export class AppComponent {

  searchInput = new FormControl('');

  constructor(){

    this.searchInput.valueChanges
      .pipe(debounceTime(500))
      .subscribe(stock => this.getStockQuoteFromServer(stock));
  }

  getStockQuoteFromServer(stock: string) {

    console.log(`Cena akcji spółki ${stock} wynosi ${(100*Math.random()).toFixed(4)}`);
  }
}
