import { NgModule, Component }      from '@angular/core';

@Component({
  selector: 'app-root',
  template:`<input type='text' value="0"
                   placeholder= "Wpisz temperaturę" [(ngModel)] = "temp">
  <button (click)="toggleFormat()">Zmień format</button>
  <br>W stopniach Celsjusza {{targetFormat}} ta temperatura wynosi {{temp | temperature: format | number:'1.1-2'}}` // <2>

})
export class AppComponent {

  temp: number;
  toCelsius: boolean=true;
  targetFormat: string ='Celsjusza';
  format: string='FnaC'; // <3>

  toggleFormat(){ // <4>

    this.toCelsius = !this.toCelsius;
    this.format = this.toCelsius? 'FnaC': 'CnaF';

    this.targetFormat = this.toCelsius?'Celsjusza':'Fahrenheita';
  }
}
