import { Component } from '@angular/core';
import {FormGroup, FormControl} from "@angular/forms";

@Component({
  selector: 'app-root',
  template: `
    <form [formGroup]="myFormModel">
      <div>ID produktu: <input type="text" formControlName="id"></div>
      <div>Opis:        <input type="text" formControlName="description"></div>
      <div>Sprzedawca:  <input type="text" formControlName="seller"></div>
    </form>
    <button (click)="updateEntireForm()">Zapełnij</button>
    <button (click)="updatePartOfTheForm()">Aktualizuj opis</button>
    <button (click)="myFormModel.reset()">Resetuj</button>
  `
})
export class AppComponent {
  myFormModel: FormGroup;

  constructor() {
    this.myFormModel = new FormGroup({
      id: new FormControl(''),
      description: new FormControl(''),
      seller: new FormControl('')
    });
  }

  updateEntireForm() {
    this.myFormModel.setValue({
      id: 123,
      description: 'Świetny produkt',
      seller: 'Firma XYZ'
    });
  }
  updatePartOfTheForm() {
    this.myFormModel.patchValue({
      description: 'Najlepszy produkt'
    });
  }
}
