import { LoginPage } from './login.po';
import { HomePage } from './home.po';
import {browser} from 'protractor';

describe('Strona logowania', () => {
  let loginPage: LoginPage;
  let homePage: HomePage;

  beforeEach(() => {
    loginPage = new LoginPage();
  });

  it('powinna nawigować do strony logowania i logować użytkownika', () => {
    loginPage.navigateToLogin();
    loginPage.login('Jaś', 'hasło');

    const url = browser.getCurrentUrl();
    expect(url).toContain('/home');

    homePage = new HomePage();
    expect(homePage.getHeaderText()).toEqual('Komponent strony głównej');
  });

  it('powinna pozostać na stronie logowania, jeśli wprowadzono nieprawidłowe poświadczenia', () => {
    loginPage.navigateToLogin();
    loginPage.login('Jaś', 'złehasło');

    const url = browser.getCurrentUrl();
    expect(url).toContain('/login');
    expect(loginPage.getErrorMessage().isPresent()).toBe(true);

  });
});
