import { Component } from '@angular/core';

@Component({
  selector: 'app-root',
  template: `<input value="0"
                    type="text"
                    [(ngModel)]="temp"
                    placeholder="Wpisz temperaturę">
    <button (click)="toggleFormat()">Zmień format</button>
    <br>W stopniach {{ targetFormat }} ta temperatura wynosi {{ temp | temperature: format | number:'1.1-2' }}` // <2>
})
export class AppComponent {
  temp: number;
  format: string = 'FnaC'; // <3>
  toCelsius: boolean = true;
  targetFormat: string = 'Celsjusza';

  toggleFormat() { // <4>
    this.toCelsius = !this.toCelsius;
    this.format = this.toCelsius ? 'FnaC' : 'CnaF';
    this.targetFormat = this.toCelsius ?'Celsjusza' : 'Fahrenheita';
  }
}
