import {Component} from "@angular/core";
import {HttpClient} from "@angular/common/http";
import {Observable} from "rxjs";
import {map} from "rxjs/operators";

@Component({
  selector: 'app-root',
  template: `<h1>Dodaj nowy produkt</h1>
  <form #f="ngForm" (ngSubmit) = "addProduct(f.value)" >
    Nazwa: <input id="productTitle" name="title" ngModel>
    <br>
    Cena: <input id="productPrice" name="price" ngModel>
    <br>
    <button type="submit">Dodaj produkt</button>
  </form>
  {{response$ | async}}
  `})
export class AppComponent {

  response$: Observable<string>;

  constructor(private httpClient: HttpClient) {}

  addProduct(formValue){
    this.response$=this.httpClient.post<{message: string}>("/api/product",
      formValue)
      .pipe(
        map (data=> data.message)
      );
  }
}
