import {Component, OnInit} from '@angular/core';
import {Observable, EMPTY} from 'rxjs';
import {FormControl} from "@angular/forms";
import {HttpClient} from "@angular/common/http";
import {catchError, debounceTime, switchMap} from "rxjs/operators";

@Component({
  selector: "app-root",
  template: `
    <h2>Obserowalna pogoda</h2>
    <input type="text" placeholder="Wpisz miasto" [formControl]="searchInput">
    <h3>{{weather}}</h3>
  `
})
export class AppComponent implements OnInit{
  private baseWeatherURL = 'http://api.openweathermap.org/data/2.5/weather?q=';
  // To run this app, you need to first request your own free key
  // at http://api.openweathermap.org and replace 12345 with your own key.
  // Otherwise you'll get the 401 error
  private urlSuffix = "&units=imperial&appid=12345";

  searchInput = new FormControl();
  weather: string;

  constructor(private http:HttpClient){ }

  ngOnInit(){
    this.searchInput.valueChanges
      .pipe(debounceTime(200),
            switchMap(city => this.getWeather(city))
      )
      .subscribe(
        res => {
          this.weather =
            `Aktualna temperatura wynosi  ${res['main'].temp}F, ` +
            `wilgotność: ${res['main'].humidity}%`;
        },
        err => console.log(`Nie można uzyskać informacji o pogodzie. Kod błędu: %s, URL: %s`, err.message, err.url)
      );
  }

  getWeather(city: string): Observable<any> {
    return this.http.get(this.baseWeatherURL + city + this.urlSuffix)
      .pipe(
        catchError(err => {
          if (err.status === 404) {
            console.log(`Nie znaleziono miasta ${city}`);
            return EMPTY;
          } else if (err.status === 401) {
            console.log(`
              Aby uruchomić tę aplikację, musisz najpierw uzyskać własny klucz
              na stronie http://api.openweathermap.org i zastąpić nim sekwencję 12345.
              W przeciwnym razie uzyskasz błąd 401.
            `);
            return EMPTY;
          }
        })
      );
  }
}
