import {ChildComponent} from "./child.component";
import {AfterViewInit, Component, QueryList, ViewChild, ViewChildren} from "@angular/core";
@Component({
  selector: 'app-root',
  template: `
    <h1>Komponent nadrzędny</h1>
    <child name= "Jaś" #child1></child>

    <child name= "Małgosia" #child2></child>

    <button (click) = "child2.greet()">Wywołanie greet() na potomku 2</button>

    <button (click)="greetAllChildren()">Wywołanie greet() na obu potomkach</button>
  `
})
export class AppComponent implements AfterViewInit {
  @ViewChild('child1')
  firstChild: ChildComponent;  // reference to one child

  @ViewChildren(ChildComponent)
  allChildren: QueryList<ChildComponent>; // reference to all instances of ChildComponent

  ngAfterViewInit() {
    this.firstChild.greet();
  }

  greetAllChildren(){
     this.allChildren.forEach(child => child.greet());
  }
}
