// Plik: r12/stockDirectiveBehaviorSpec.js
describe('Zachowanie dyrektywy widżetu giełdowego', function() {

  beforeEach(module('stockMarketApp'));

  var compile, mockBackend, rootScope;

  // Krok 1
  beforeEach(inject(function($compile, $httpBackend, $rootScope) {
    compile = $compile;
    mockBackend = $httpBackend;
    rootScope = $rootScope;
  }));

  it('W zakresie powinny być odpowiednie funkcje i dane.',
      function() {
    // Krok 2
    var scope = rootScope.$new();
    var scopeClickCalled = '';
    scope.myStock = {
      name: 'Najlepszy towar',
      price: 100,
      previous: 200
    };
    scope.title = 'najlepszy';
    scope.userClick = function(stockPrice,
                               stockPrevious,
                               stockName) {
      scopeClickCalled = stockPrice +
        ';' + stockPrevious +
        ';' + stockName;
    };

    // Step 3
    mockBackend.expectGET('stock.html').respond(
        '<div ng-bind="stockTitle"></div>' +
        '<div ng-bind="stockData.price"></div>');

    // Step 4
    var element = compile(
        '<div stock-widget' +
        ' stock-data="myStock"' +
        ' stock-title="To jest {{title}}"' +
        ' when-select="userClick(stockPrice, ' +
            'stockPrevious, stockName)">' +
        '</div>'
    )(scope);

    // Krok 5
    scope.$digest();
    mockBackend.flush();

    // Krok 6
    var compiledElementScope = element.isolateScope();

    expect(compiledElementScope.stockData)
        .toEqual(scope.myStock);
    expect(compiledElementScope.getChange(
      compiledElementScope.stockData)).toEqual(-50);


    // Krok 7
    expect(scopeClickCalled).toEqual('');

    compiledElementScope.onSelect();

    expect(scopeClickCalled).toEqual('100;200;Najlepszy towar');
  });
});
