// Plik: r05/simple-angularjs-service/app.js

angular.module('notesApp', [])
  .controller('MainCtrl', [function() {
    var self = this;
    self.tab = 'first';
    self.open = function(tab) {
      self.tab = tab;
    };
  }])
  .controller('SubCtrl', ['ItemService',
      function(ItemService) {
    var self = this;
    self.list = function() {
      return ItemService.list();
    };

    self.add = function() {
      ItemService.add({
        id: self.list().length + 1,
        label: 'Element ' + self.list().length
      });
    };
  }])
  .factory('ItemService', [function() {
    var items = [
      {id: 1, label: 'Element 0'},
      {id: 2, label: 'Element 1'}
    ];
    return {
      list: function() {
        return items;
      },
      add: function(item) {
        items.push(item);
      }
    };
  }]);
