'use strict';

angular.module('WorkoutBuilder')
  .controller('ExercisesNavController', ['$scope', 'WorkoutService', 'WorkoutBuilderService', function ($scope, WorkoutService, WorkoutBuilderService) {
      $scope.addExercise = function (exercise) {
          WorkoutBuilderService.addExercise(exercise);
      }
      var init = function () {
          $scope.exercises = WorkoutService.getExercises();
      };
      init();
  }]);

angular.module('WorkoutBuilder')
  .controller('ExerciseListController', ['$scope', 'WorkoutService', '$location', function ($scope, WorkoutService, $location) {
      $scope.goto = function (exercise) {
          $location.path('/builder/exercises/' + exercise.name);
      }
      var init = function () {
          WorkoutService.getExercises().success(function (data) {
              $scope.exercises = data;
          });
      };
      init();
  }]);

angular.module('WorkoutBuilder')
  .controller('ExerciseDetailController', ['$scope', 'WorkoutService', '$routeParams', 'ExerciseBuilderService', '$location', function ($scope, WorkoutService, $routeParams, ExerciseBuilderService, $location) {

      $scope.save = function () {
          $scope.submitted = true;      // wymuszenie sprzedzenia poprawności
          if ($scope.formExercise.$invalid) return;
          $scope.exercise = ExerciseBuilderService.save();
          $scope.formExercise.$setPristine();
          $scope.submitted = false;
      };

      $scope.hasError = function (modelController, error) {
          return (modelController.$dirty || $scope.submitted) && error;
      };

      $scope.reset = function () {
          $scope.exercise = ExerciseBuilderService.startBuilding($routeParams.id);
          $scope.formExercise.$setPristine();
          $scope.submitted = false;
      };

      $scope.canDeleteExercise = function () {
          return ExerciseBuilderService.canDeleteExercise();
      }

      $scope.deleteExercise = function () {
          ExerciseBuilderService.delete();
          $location.path('/builder/exercises/');
      };

      $scope.addVideo = function () {
          ExerciseBuilderService.addVideo();
      };

      $scope.deleteVideo = function (index) {
          ExerciseBuilderService.deleteVideo(index);
      };

      var init = function () {
          // Nie używamy właściwości resolve definicji trasy podczas wczytywania ćwiczeń, jak robimy w przypadku treningów.
          $scope.exercise = ExerciseBuilderService.startBuilding($routeParams.id);
      };

      init();
  }]);