describe("Dyrektywy", function () {
    var $compile, $rootScope, $scope;

    beforeEach(module('app'));

    beforeEach(inject(function (_$compile_, _$rootScope_) {
        $compile = _$compile_;
        $rootScope = _$rootScope_;
        $scope = $rootScope.$new();
    }));

    describe("Dyrektywa remote-validator", function () {
        var inputElement;
        beforeEach(inject(function () {
            $scope.validate = function (value) { };
            inputElement = "<form name='testForm'><input type='text' name='unique' ng-model='name' remote-validator='unique' remote-validator-function='validate(value)' /></form>";
        }));

        it("powinna zgłosić błąd jeśli ng-model nie jest zdefiniowany", function () {
            expect($compile("<div remote-validator='unique' remote-validator-function='validate(value)'></div>")).toThrow();

        });

        it("wczytać dyrektywę bez zgłaszania błędów", function () {
            $compile(inputElement)($scope);
        });

        it("powinna sprawdzić unikalność nazwy po zmianie zawartości pola", inject(function ($q) {
            spyOn($scope, "validate").and.returnValue($q.when(true));
            $compile(inputElement)($scope);
            $scope.testForm.unique.$setViewValue("testy");
            expect($scope.validate).toHaveBeenCalled();
        }));

        it("w razie nieudanej walidacji pola 'unqiue' powinna zapisać błąd w kontrolerze modelu", inject(function ($q) {
            spyOn($scope, "validate").and.returnValue($q.reject());
            $compile(inputElement)($scope);
            $scope.testForm.unique.$setViewValue("testy");
            expect($scope.validate).toHaveBeenCalled();
            $scope.$digest();

            expect($scope.testForm.$valid).toBe(false);
            expect($scope.testForm.unique.$valid).toBe(false);
            expect($scope.testForm.unique.$error.unique).toBe(true);


        }));

        it("nie powinna zawierać błędu jeśli zdalna walidacja zakończyła się pomyślnie", inject(function ($q) {
            spyOn($scope, "validate").and.returnValue($q.when(true));
            $scope.name = "initialValue";
            $compile(inputElement)($scope);
            $scope.testForm.unique.$setViewValue("testy");
            $scope.$digest();

            expect($scope.validate).toHaveBeenCalled();
            expect($scope.testForm.$valid).toBe(true);
            expect($scope.testForm.unique.$valid).toBe(true);
            expect($scope.testForm.unique.$error.unique).toBeUndefined(false);
        }));
    });

    describe("Dyrektywa remote-validator wraz z busy-indicator", function () {
        var inputElement;
        beforeEach(inject(function ($q) {
            $scope.validate = function () { };
            inputElement = "<form name='testForm'><div busy-indicator=''><input type='text' name='unique' ng-model='name' remote-validator='unique' remote-validator-function='validate(value)' /></div></form>";
        }));

        it("powinna wczytać wskaźnik działania", function () {
            var e = $compile(inputElement)($scope);

            expect(e.html().indexOf("glyphicon glyphicon-refresh") > 0).toBe(true);
        });

        it("powinny wyświetlić wskaźnik podczas wykonywania zdalnej walidacji, a następnie, po zakończeniu operacji, go ukryć", inject(function ($q) {
            var defer = $q.defer(),
                html = $compile(inputElement)($scope),
                childElementScope = html.children().scope();

            spyOn($scope, "validate").and.returnValue(defer.promise);

            expect(childElementScope.busy).toBeUndefined();

            $scope.testForm.unique.$setViewValue("testy");
            expect(childElementScope.busy).toBe(true);

            defer.resolve(true);
            $scope.$digest();

            expect(childElementScope.busy).toBe(false);

        }));
    });

    describe("Walidator przycisku ajax", function () {

        beforeEach(inject(function () {
            $scope.save = function (value) { };
            $scope.submitted = false;
        }));
        it("powinien wczytać walidator przycisku", function () {
            var inputElement = '<ajax-button on-click="save()">Zapisz</ajax-button>';
            var e = $compile(inputElement)($scope);
            expect(e[0] instanceof HTMLButtonElement).toBe(true);

        });

        it("powinien wczytac wskaźnik działania podczas wykonywania żądania", inject(function ($q) {
            var defer = $q.defer();
            spyOn($scope, "save").and.returnValue(defer.promise);
            var inputElement = '<ajax-button on-click="save()">Zapisz</ajax-button>';
            var e = $compile(inputElement)($scope),
                isolatedScope = e.isolateScope();

            e[0].click();

            expect(isolatedScope.busy).toBe(true);
            expect($scope.save).toHaveBeenCalled();

            defer.resolve(true);
            $scope.$digest();
            expect(isolatedScope.busy).toBe(false);
        }));

        it("powinien wczytać wskaźnik działania koedy flaga submitting przyjmie wartość true", inject(function ($q) {
            spyOn($scope, "save").and.returnValue($q.when(true));
            var inputElement = '<ajax-button on-click="save()" submitting="{{submitted}}">Zapisz</ajax-button>';
            var e = $compile(inputElement)($scope),
                isolatedScope = e.isolateScope();

            $scope.submitted = true;

            e[0].click();

            expect(isolatedScope.busy).toBe(true);
            expect($scope.save).toHaveBeenCalled();

            $scope.submitted = false;
            $scope.$digest();
            expect(isolatedScope.busy).toBe(false);
        }));

    });
});