describe("Współdzielone usługi", function () {
    beforeEach(module('app'));
    
    describe("Usługa WorkoutService", function () {
        var WorkoutService, $httpBackend,
        collectionUrl = "https://api.mongolab.com/api/1/databases/testowabazadanych/collections",
        apiKey = "kluczTestowy";

        beforeEach(module(function (WorkoutServiceProvider, ApiKeyAppenderInterceptorProvider) {
            WorkoutServiceProvider.configure("testowabazadanych");
            ApiKeyAppenderInterceptorProvider.setApiKey("kluczTestowy")
        }));

        beforeEach(inject(function (_WorkoutService_, _$httpBackend_) {
            WorkoutService = _WorkoutService_;
            $httpBackend = _$httpBackend_;
        }));

        it("powinien wczytać usługę WorkoutService", function () {
            expect(WorkoutService).toBeDefined();
        });

        it("powinien przesłać żądanie do odpowiedniego punktu końcowego", function () {
            $httpBackend.expectGET(collectionUrl + "/workouts?apiKey=" + "kluczTestowy").respond([]);
            WorkoutService.getWorkouts();
            $httpBackend.flush();
        });

        it("powinien zwrócić wszystkie treningi", inject(function (WorkoutPlan) {
            $httpBackend.expectGET(collectionUrl + "/workouts?apiKey=" + "kluczTestowy").respond([{ name: "Trening1", title: "trening1" }, { name: "Trening1", title: "trening1" }]);
            var result = null;
            WorkoutService.getWorkouts()
                          .then(function (workouts) {
                              result = workouts;
                          });
            $httpBackend.flush();

            expect(result.length).toBe(2);
            expect(result[0] instanceof WorkoutPlan).toBe(true);
        }));

        it("powinien zwrócić trening o odpowiedniej nazwie", inject(function (WorkoutPlan, $q) {
            spyOn(WorkoutService.Exercises, "query").and.returnValue({ $promise: $q.when([{ name: "ćwiczenie1", title: "ćwiczenie 1" }]) });
            $httpBackend.expectGET(collectionUrl + "/workouts/treningtestowy?apiKey=" + "kluczTestowy").respond({ name: "Trening1", title: "Trening 1", restBetweenExercise: 30 });
            var result = null;
            WorkoutService.getWorkout("treningtestowy")
                          .then(function (workout) { result = workout; });
            $httpBackend.flush();

            expect(result.name).toBe("Trening1");
            expect(result instanceof WorkoutPlan).toBe(true);
            expect(WorkoutService.Exercises.query).toHaveBeenCalled();
        }));

        it("powinien prawidłowo połączyć ćwiczenia z konkretnym treningiem w metodzie getWorkout", inject(function (WorkoutPlan, Exercise, $q) {
            spyOn(WorkoutService.Exercises, "query").and.returnValue({ $promise: $q.when([{ name: "ćwiczenie1", title: "ćwiczenie 1" }, { name: "ćwiczenie2", title: "ćwiczenie 2" }, { name: "ćwiczenie3", title: "ćwiczenie 3" }], { name: "ćwiczenie4", title: "ćwiczenie 4" }) });
            $httpBackend.expectGET(collectionUrl + "/workouts/treningtestowy?apiKey=" + "kluczTestowy").respond({ name: "Trening2", title: "Trening 1", restBetweenExercise: 30, exercises: [{ name: "ćwiczenie2", duration: 31 }, { name: "ćwiczenie4", duration: 31 }] });
            var result = null;
            WorkoutService.getWorkout("treningtestowy")
                          .then(function (workout) { result = workout; });
            $httpBackend.flush();

            expect(result.name).toBe("Trening2");
            expect(WorkoutService.Exercises.query).toHaveBeenCalled();
            expect(result instanceof WorkoutPlan).toBe(true);
            expect(result.exercises.length).toBe(2);
            expect(result.exercises[0].name).toBe("ćwiczenie2");
            expect(result.exercises[1].name).toBe("ćwiczenie4");
        }));

        afterEach(function () {
            $httpBackend.verifyNoOutstandingExpectation();
            $httpBackend.verifyNoOutstandingRequest();
        });
    });
});