describe("Trasy aplikacji", function () {
    beforeEach(module('app'));

    it("domyślnie powinna zostać wybrana trasa wykonywania treningu", inject(function ($rootScope, $location, $route, $httpBackend) {    // Jeśli nie wstrzykniemy zależności do usługi $route, to znana trasy nie nastąpi i to nawet jeśli zmienimy adres korzystając z usługi $location.
        $httpBackend.whenGET("partials/workout/start.html").respond("<div/>");
        $location.path("/");
        $rootScope.$digest();
        expect($location.path()).toBe("/start");
        expect($route.current.templateUrl).toBe("partials/workout/start.html");
        expect($route.current.controller).toBeUndefined();
    }));

    it("powinien zostać wczytany trening.", inject(function ($rootScope, $location, $route, $httpBackend) {
        $httpBackend.whenGET("partials/workout/workout.html").respond("<div/>");
        $location.path("/workout/treningTestowy");
        $rootScope.$digest();
        expect($location.path()).toBe("/workout/treningTestowy");
        expect($route.current.params.id).toBe('treningTestowy');
    }));

    it("powinien zostać uruchomiony konstruktor treningów.", inject(function ($rootScope, $location, $route, $httpBackend,WorkoutBuilderService) {
        spyOn(WorkoutBuilderService, "startBuilding");
        $httpBackend.whenGET("partials/workoutbuilder/workout.html").respond("<div/>");
        $location.path("/builder/workouts/new");
        $rootScope.$digest();
        expect($location.path()).toBe("/builder/workouts/new");
        expect(WorkoutBuilderService.startBuilding).toHaveBeenCalled();
        expect(WorkoutBuilderService.startBuilding.calls.count()).toBe(1);
    }));

});