'use strict';

/* Dyrektywy */
angular.module('app').directive('ngConfirm', [function () {
    return {
        restrict: 'A',
        link: function (scope, element, attrs) {
            element.bind('click', function () {
                var message = attrs.ngConfirmMessage || 'Czy jesteś pewny?';
                if (message && confirm(message)) {
                    scope.$apply(attrs.ngConfirm);
                }
            });
        }
    }
}]);

// Walidator dla wersji starszych od Angular 1.3. Należy go używać w razie korzystania ze starszych wersji Angular
//angular.module('app').directive('remoteValidator', ['$parse', function ($parse) {
//    return {
//        require: 'ngModel',
//        link: function (scope, elm, attr, ngModelCtrl) {
//            var expfn = $parse(attr["remoteValidatorFunction"]);
//            var validatorName = attr["remoteValidator"];
//            ngModelCtrl.$parsers.push(function (value) {
//                var result = expfn(scope, { 'value': value });
//                if (result.then) {
//                    result.then(function (data) { // gdy zwracanym obiektem jest obietnica
//                        ngModelCtrl.$setValidity(validatorName, true);
//                    }, function (error) {
//                        ngModelCtrl.$setValidity(validatorName, false);
//                    });
//                }
//                return value;
//            });
//        }
//    }
//}]);

// Walidator dla wersji Angular zaczynając od 1.3. Stosuj go jeśli używasz Angular 1.3 lub nowszej wersji.
angular.module('app').directive('remoteValidator', ['$parse', function ($parse) {
    return {
        require: 'ngModel',
        link: function (scope, elm, attr, ngModelCtrl) {
            var expfn = $parse(attr["remoteValidatorFunction"]);
            var validatorName = attr["remoteValidator"];
            ngModelCtrl.$asyncValidators[validatorName] = function (value) {
                return expfn(scope, { 'value': value });
            }
        }
    }
}]);
