'use strict';

angular.module('WorkoutBuilder')
  .controller('WorkoutListController', ['$scope', 'WorkoutService', '$location', function ($scope, WorkoutService, $location) {
      $scope.goto = function (workout) {
          $location.path('/builder/workouts/' + workout.name);
      }
      var init = function () {
          WorkoutService.getWorkouts().success(function (data) {
              $scope.workouts = data;
          });
      };
      init();
  }]);

angular.module('WorkoutBuilder')
  .controller('WorkoutDetailController', ['$scope', 'WorkoutBuilderService', 'selectedWorkout', '$location', '$routeParams', function ($scope, WorkoutBuilderService, selectedWorkout, $location, $routeParams) {
      $scope.removeExercise = function (exercise) {
          WorkoutBuilderService.removeExercise(exercise);
      };

      $scope.save = function () {
          $scope.submitted = true;      // wymuszenie sprzedzenia poprawności
          if ($scope.formWorkout.$invalid) return;
          $scope.workout = WorkoutBuilderService.save();
          $scope.formWorkout.$setPristine();
          $scope.submitted = false;
      }

      $scope.$watch('formWorkout.exerciseCount', function (newValue) {
          if (newValue) {
              newValue.$setValidity("count", $scope.workout.exercises.length > 0);
          }
      });

      $scope.$watch('workout.exercises.length', function (newValue, oldValue) {
          if (newValue != oldValue) {
              $scope.formWorkout.exerciseCount.$dirty = true;
              $scope.formWorkout.$setDirty();
              $scope.formWorkout.exerciseCount.$setValidity("count", newValue > 0);
          }
      });

      //var restWatch = $scope.$watch('formWorkout.restBetweenExercise', function (newValue) {
      //    // Logika konwersji zaczerpnięta z postu http://stackoverflow.com/questions/596467/how-do-i-convert-a-number-to-an-integer-in-javascript
      //    if (newValue) {
      //        newValue.$parsers.unshift(function (value) {
      //            return isNaN(parseInt(value)) ? value : parseInt(value);
      //        });
      //        newValue.$formatters.push(function (value) {
      //            return isNaN(parseInt(value)) ? value : parseInt(value);
      //        });
      //        restWatch(); // wyrejestrowanie czujki po pierwszym użyciu.
      //    }
      //});
      $scope.hasError = function (modelController, error) {
          return (modelController.$dirty || $scope.submitted) && error;
      }

      $scope.reset = function () {
          $scope.workout = WorkoutBuilderService.startBuilding($routeParams.id);
          $scope.formWorkout.$setPristine();
          $scope.submitted = false;      // wymuszenie sprawdzenia poprawności
      };

      $scope.moveExerciseTo = function (exercise, location) {
          WorkoutBuilderService.moveExerciseTo(exercise, location);
      };

      $scope.durations = [{ title: "15 sekund", value: 15 },
                          { title: "30 sekund", value: 30 },
                          { title: "45 sekund", value: 45 },
                          { title: "1 minuta", value: 60 },
                          { title: "1 minuta i 15 sekund", value: 75 },
                          { title: "1 minuta i 30 sekund", value: 90 },
                          { title: "1 minuta i 45 sekund", value: 105 },
                          { title: "2 minuty", value: 120 },
                          { title: "2 minuty i 15 sekund", value: 135 },
                          { title: "2 minuty i 30 sekund", value: 150 },
                          { title: "2 minuty i 45 sekund", value: 165 },
                          { title: "3 minuty", value: 180 },
                          { title: "3 minuty i 15 sekund", value: 195 },
                          { title: "3 minuty i 30 sekund", value: 210 },
                          { title: "3 minuty i 45 sekund", value: 225 },
                          { title: "4 minuty", value: 240 },
                          { title: "4 minuty i 15 sekund", value: 255 },
                          { title: "4 minuty i 30 sekund", value: 270 },
                          { title: "4 minuty i 45 sekund", value: 285 },
                          { title: "5 minut", value: 300 }];
 
      $scope.canDeleteWorkout = function () {
          return WorkoutBuilderService.canDeleteWorkout();
      }

      $scope.deleteWorkout = function () {
          WorkoutBuilderService.delete();
          $location.path('/builder/workouts/');
      };
      var init = function () {
          $scope.workout = selectedWorkout; // wyznaczony obiekt treningu
      };
      init();
  }]);