import {Component, Input, ViewEncapsulation, HostBinding, Output, EventEmitter, ChangeDetectionStrategy} from '@angular/core';
import template from './task.html!text';

@Component({
  selector: 'ngc-task',
  host: {
    class: 'task'
  },
  template,
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class Task {
  // Model task może zostać dołączony na elemencie nadrzędnym wewnątrz widoku.
  @Input() task;
  // Poinformuj element nadrzędny o modyfikacjach zadania.
  @Output() taskUpdated = new EventEmitter();
  @Output() taskDeleted = new EventEmitter();

  @HostBinding('class.task--done')
  get done() {
    return this.task && this.task.done;
  }

  // Użyj tej funkcji do aktualizacji stanu zaznaczenia zadania.
  markDone(checked) {
    this.taskUpdated.next({
      title: this.task.title,
      done: checked ? +new Date() : null
    });
  }

  // Jeśli chcemy usunąć zadanie, po prostu emitujemy zdarzenie i pozwalamy komponentowi nadrzędnemu zająć się resztą.
  deleteTask() {
    this.taskDeleted.next();
  }

  // W momencie zapisywania zmian w edytorze aktualizujemy zadanie i generujemy zdarzenie.
  onTitleSaved(title) {
    this.taskUpdated.next({
      title,
      done: this.done
    });
  }
}
