import {Pipe} from '@angular/core';
// Używamy biblioteki Moment.js do konwersji daty na wersję kalendarzową.
import Moment from 'moment';
// Wczytaj tłumaczenia dla języka polskiego.
import 'moment/locale/pl';

@Pipe({
  name: 'calendarTime'
})
export class CalendarTimePipe {
  // Metoda transform zostanie wywołana po użyciu potoku w szablonie komponentu.
  transform(value) {
    if (value && (value instanceof Date || typeof value === 'number')) {
      return new Moment(value).locale('pl').calendar();
    }
  }
}
