import {Component, Input, Output, ViewEncapsulation, EventEmitter, ChangeDetectionStrategy} from '@angular/core';
import template from './duration.html!text';
import {parseDuration} from '../../utilities/time-utilities';

@Component({
  selector: 'ngc-duration',
  host: {
    class: 'duration'
  },
  template,
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class Duration {
  @Input() duration;
  @Output() durationChange = new EventEmitter();

  onEditSaved(formattedDuration) {
    this.durationChange.next(formattedDuration ? parseDuration(formattedDuration) : null);
  }
}
