import {Component, ViewEncapsulation, Inject, Input} from '@angular/core';
import template from './activities.html!text';
import {ActivityService} from './activity-service/activity-service';

@Component({
  selector: 'ngc-activities',
  host: {
    class: 'activities'
  },
  template,
  encapsulation: ViewEncapsulation.None
})
export class Activities {
  @Input() activitySubject;

  constructor(@Inject(ActivityService) activityService) {
    this.activityService = activityService;
  }

  ngOnChanges(changes) {
    if (changes.activitySubject) {
      // Jeśli mamy już aktywną sybskrypcję, musimy ją anulować.
      if (this.activitiesChangeSubscription) {
        this.activitiesChangeSubscription.unsubscribe();
      }

      // Po aktualizacji danych projektu musimy ponownie przefiltrować dane pod kątem aktywności.
      this.activitiesChangeSubscription = this.activityService.change.subscribe((activities) => {
        // Przefiltruj aktywności na podstawie identyfikatora projektu.
        this.activities = activities
          .filter((activity) => activity.subject === this.activitySubject.id);
        this.onSelectionChange();
      });
    }
  }

  // Jeśli zmieni się wartość zaznaczenia w suwaku, ponownie przefiltruj aktywności.
  onSelectionChange(selection = this.selection) {
    this.selection = selection;
    // Zapamiętaj tylko te aktywności, które mieszczą się w wybranym w suwaku zakresie.
    this.selectedActivities = this.selection ? this.activities.filter(
      (activity) => activity.time >= this.selection.start && activity.time <= this.selection.end
    ) : this.activities;
  }

  // Określ wyrównanie na podstawie indeksu. Aktywności parzyste wyrównaj do lewej, a nieparzyste do prawej.
  getAlignment(index) {
    return index % 2 === 0 ? 'left' : 'right';
  }

  // Funkcja sprawdza, czy to pierwsza aktywność.
  isFirst(index) {
    return index === 0;
  }

  // Funkcja sprawdza, czy to ostatnia aktywność.
  isLast(index) {
    return index === this.selectedActivities.length - 1;
  }

  // W momencie niszczenia komponentu musimy anulować subskrypcję.
  ngOnDestroy() {
    this.activitiesChangeSubscription.unsubscribe();
  }
}
