import {Pipe} from '@angular/core';
// Używamy biblioteki Moment.js do konwersji daty na relatywny opis czasu.
import Moment from 'moment';
// Wczytaj tłumaczenia dla języka polskiego.
import 'moment/locale/pl';

@Pipe({
  // Określenie nazwy używanej w szablonach.
  name: 'fromNow'
})
// Potok zamieni daty i znaczniki czasowe na względny opis czasu przy użyciu biblioteki Moment.js.
export class FromNowPipe {
  // Metoda transform zostanie wywołana po użyciu potoku w szablonie komponentu.
  transform(value) {
    if (value && (value instanceof Date || typeof value === 'number')) {
      return new Moment(value).locale('pl').fromNow();
    }
  }
}
