import {Pipe, Inject} from '@angular/core';
import {TagsService} from './tags-service';

@Pipe({
  name: 'tags',
  // Ponieważ potok zależy od usługi, jest to potok stanowy, więc ustawiamy opcję pure na wartość false.
  pure: false
})
export class TagsPipe {
  constructor(@Inject(TagsService) tagsService) {
    this.tagsService = tagsService;
  }

  // Metoda ta zostanie wywołana, gdy potok zostanie użyty wewnątrz szablonu.
  transform(value) {
    if (typeof value !== 'string') {
      return value;
    }
    // Potok używa usługi TagsService do przetworzenia całego tekstu.
    return this.tagsService.parse(value);
  }
}
