import {Directive, HostListener, Input, HostBinding} from '@angular/core';

@Directive({
  selector: '[draggable]',
  host: {
    class: 'draggable',
    // Poza klasą chcemy również ustawić atrybut HTML draggable, aby włączyć możliwość przeciągania elementu.
    draggable: 'true'
  }
})
export class Draggable {
  // Wejście draggableData może być dowolnego typu i zostanie przekształcone do formatu JSON i przekazane do miejsce upuszczenia.
  // Powinny to byćdane opisujące przeciągany obiekt.
  @Input() draggableData;
  // Ten element wejściowy typu tekstowego określa typ przeciąganego obiektu, co ogranicza miejsca, w których można go upuścić.
  @Input() draggableType;
  // Jeśli element jest przeciągany, dodajemy klasę CSS umożliwiającą zmianę wyglądu.
  @HostBinding('class.draggable--dragging') dragging;

  // Nasłuchujemy zdarzenia dragstart i inicjalizujemy obiekt dataTransfer.
  @HostListener('dragstart', ['$event'])
  onDragStart(event) {
    event.dataTransfer.effectAllowed = 'move';
    // Zamieniamy dane na format JSON i ustawiamy je w obiekcie dataTransfer.
    event.dataTransfer.setData('application/json', JSON.stringify(this.draggableData));
    // Dodając draggableType jako klucz w obiekcie dataTransfer, umożliwaiamy miejscom upuszczenia sprawdzenie typu przed przyjęciem danych.
    event.dataTransfer.setData(`draggable-type:${this.draggableType}`, '');
    this.dragging = true;
  }

  // Dla zdarzenia dragend, po prostu ustawiamy znacznik dragging na wartość false.
  @HostListener('dragend')
  onDragEnd() {
    this.dragging = false;
  }
}
