import {Component, Input, Output, ViewEncapsulation, EventEmitter} from '@angular/core';
import template from './comment.html!text';

@Component({
  selector: 'ngc-comment',
  host: {
    class: 'comment'
  },
  template,
  encapsulation: ViewEncapsulation.None
})
export class Comment {
  // Czas komentarza jako znacznik czasowy.
  @Input() time;
  // Obiekt użytkownika, który utworzył komentarz.
  @Input() user;
  // Zawartość komentarza.
  @Input() content;
  // Jeśli zmodyfikowano komentarz, zostanie wyemitowane to zdarzenie.
  @Output() commentEdited = new EventEmitter();

  onContentSaved(content) {
    this.commentEdited.next(content);
  }
}
