import { NgModule } from '@angular/core';

// Wczytaj moduł zawierający podstawowe dyrektywy.
import {CommonModule} from '@angular/common';

// Wczytaj moduł zawierający komponenty interfejsu użytkownika.
import {UIModule} from '../ui/ui.module';

import {DraggableModule} from '../draggable/draggable.module'

// Wczytaj listę zadań i zadanie jako zależności modułu.
import {TaskList} from './task-list';
import {Task} from './task/task';

// Komponent do wpisywania nowych zadań.
import {EnterTask} from './enter-task/enter-task';

import {InfiniteScroll} from '../infinite-scroll/infinite-scroll';

import {RouterModule} from '@angular/router';

// Utwórz moduł listy zadań.
@NgModule({
  declarations: [TaskList, Task, EnterTask, InfiniteScroll],
  imports: [CommonModule, UIModule, DraggableModule, RouterModule],
  exports: [TaskList]
})
export class TaskListModule {}
