import {Component, ViewEncapsulation, Inject, forwardRef} from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import template from './project-task-details.html!text';
import {Project} from '../project';

@Component({
  selector: 'ngc-project-task-details',
  host: {
    class: 'task-details'
  },
  template,
  encapsulation: ViewEncapsulation.None
})
export class ProjectTaskDetails {
  constructor(@Inject(forwardRef(() => Project)) project,
              @Inject(ActivatedRoute) route) {
    this.project = project;
    this.route = route;
  }

  ngOnInit() {
    this.routeParams = this.route.params.subscribe(params => {
      const taskNr = params['nr'];
      if (this.projectChangeSubscription) {
        this.projectChangeSubscription.unsubscribe();
      }
      this.projectChangeSubscription = this.project.document.change.subscribe((data) => {
        this.task = data.tasks.find((task) => task.nr === +taskNr);
        this.projectMilestones = data.milestones || [];
      });
    });
  }

  onTitleSaved(title) {
    this.task.title = title;
    this.project.document.persist();
  }

  onDescriptionSaved(description) {
    this.task.description = description;
    this.project.document.persist();
  }

  ngOnDestroy() {
    this.projectChangeSubscription.unsubscribe();
    this.routeParams.unsubscribe();
  }

  onEffortsChange(efforts) {
    if (!efforts.estimated && !efforts.effective) {
      this.task.efforts = null;
    } else {
      this.task.efforts = efforts;
    }
    this.project.document.persist();
  }

  onMilestoneSelected(milestone) {
    this.task.milestone = milestone;
    this.project.document.persist();
  }

  onMilestoneCreated(milestone) {
    this.project.document.data.milestones = this.project.document.data.milestones || [];
    this.project.document.data.milestones.push(milestone);
    this.task.milestone = milestone;
    this.project.document.persist();
  }
}
