import { Component, OnInit } from '@angular/core';
import { MatSnackBar } from '@angular/material/snack-bar';
import { SwUpdate, VersionReadyEvent } from '@angular/service-worker';
import { filter, map, switchMap } from 'rxjs';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent implements OnInit {
  title = 'aplikacja-pogodowa';

  constructor(private updates: SwUpdate, private snackbar: MatSnackBar) {}

  ngOnInit() {
	this.updates.versionUpdates.pipe(
	  filter((evt): evt is VersionReadyEvent => evt.type === 'VERSION_READY'),
	  switchMap(() => this.snackbar.open('Dostępna jest nowa wersja!', 'Zaktualizuj').afterDismissed()),
	  filter(result => result.dismissedByAction),
	  map(() => this.updates.activateUpdate().then(() => location.reload()))
	).subscribe();
  }
}
