/* tslint:disable:no-unused-variable */

import { TestBed, inject } from '@angular/core/testing';
import { HttpClientTestingModule, HttpTestingController } from '@angular/common/http/testing';
import { StocksService } from './stocks.service';
import { MockStocksResponse, MockSymbolsList, MockNewsResponse } from './stocks.mock';

describe('Usługa: Stocks', () => { 
  const baseUrl = 'https://angular2-in-action-api.herokuapp.com'; 
  let service, http; 

  beforeEach(() => {
    TestBed.configureTestingModule({
      imports: [ HttpClientTestingModule ],
      providers: [ StocksService ]
    });
    
    service = TestBed.get(StocksService);
    http = TestBed.get(HttpTestingController);
  });

  afterEach(() => {
    http.verify();
  });

  it('powinna tworzyć instancję', () => { 
    expect(service).toBeTruthy(); 
  }); 

  it('powinna zarządzać listą spółek', () => { 
    expect(service.get()).toEqual(MockSymbolsList); 
    service.add('TEST'); 
    expect(service.get()).toEqual([...MockSymbolsList, 'TEST']); 
    service.remove('TEST'); 
    expect(service.get()).toEqual(MockSymbolsList); 
  }); 

  it('powinna ładować dane spółek z API', (done) => { 
    service.load(MockSymbolsList).subscribe(result => {
      expect(result).toEqual(MockStocksResponse);
      done();
    });

    const request = http.expectOne(baseUrl + '/stocks/snapshot?symbols=' + MockSymbolsList.join(','));
    request.flush(MockStocksResponse);
  }); 

  it('powinna ładować dane wiadomości z API', (done) => { 
    service.getNewsSnapshot('abc').subscribe(result => {
      expect(result).toEqual(MockNewsResponse);
      done();
    });

    const request = http.expectOne(baseUrl + '/stocks/news/snapshot?source=abc');
    request.flush(MockNewsResponse);
  }); 
});
