/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import com.google.android.apps.analytics.AnalyticsParameterEncoder;
import com.google.android.apps.analytics.CustomVariable;
import com.google.android.apps.analytics.CustomVariableBuffer;
import com.google.android.apps.analytics.Event;
import com.google.android.apps.analytics.Item;
import com.google.android.apps.analytics.Referrer;
import com.google.android.apps.analytics.Transaction;
import java.util.Locale;

class HitBuilder {
    private static final String GOOGLE_ANALYTICS_GIF_PATH = "/__utm.gif";
    static final String FAKE_DOMAIN_HASH = "1";
    private static final int X10_PROJECT_NAMES = 8;
    private static final int X10_PROJECT_VALUES = 9;
    private static final int X10_PROJECT_SCOPES = 11;

    HitBuilder() {
    }

    private static String constructPageviewRequestPath(Event event, Referrer referrer) {
        String string = "";
        if (event.action != null) {
            string = event.action;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        string = HitBuilder.encode(string);
        String string2 = HitBuilder.getCustomVariableParams(event);
        Locale locale = Locale.getDefault();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.8.1ma");
        stringBuilder.append("&utmn=").append(event.getRandomVal());
        if (string2.length() > 0) {
            stringBuilder.append("&utme=").append(string2);
        }
        stringBuilder.append("&utmcs=UTF-8");
        stringBuilder.append(String.format("&utmsr=%dx%d", event.screenWidth, event.screenHeight));
        stringBuilder.append(String.format("&utmul=%s-%s", locale.getLanguage(), locale.getCountry()));
        stringBuilder.append("&utmp=").append(string);
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(HitBuilder.getEscapedCookieString(event, referrer));
        if (event.getAdHitId() != 0) {
            stringBuilder.append("&utmhid=").append(event.getAdHitId());
        }
        return stringBuilder.toString();
    }

    private static String constructEventRequestPath(Event event, Referrer referrer) {
        Locale locale = Locale.getDefault();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(String.format("5(%s*%s", HitBuilder.encode(event.category), HitBuilder.encode(event.action)));
        if (event.label != null) {
            stringBuilder2.append("*").append(HitBuilder.encode(event.label));
        }
        stringBuilder2.append(")");
        if (event.value > -1) {
            stringBuilder2.append(String.format("(%d)", event.value));
        }
        stringBuilder2.append(HitBuilder.getCustomVariableParams(event));
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.8.1ma");
        stringBuilder.append("&utmn=").append(event.getRandomVal());
        stringBuilder.append("&utmt=event");
        stringBuilder.append("&utme=").append(stringBuilder2.toString());
        stringBuilder.append("&utmcs=UTF-8");
        stringBuilder.append(String.format("&utmsr=%dx%d", event.screenWidth, event.screenHeight));
        stringBuilder.append(String.format("&utmul=%s-%s", locale.getLanguage(), locale.getCountry()));
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(HitBuilder.getEscapedCookieString(event, referrer));
        if (event.getAdHitId() != 0) {
            stringBuilder.append("&utmhid=").append(event.getAdHitId());
        }
        return stringBuilder.toString();
    }

    private static void appendStringValue(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string).append("=");
        if (string2 != null && string2.trim().length() > 0) {
            stringBuilder.append(AnalyticsParameterEncoder.encode(string2));
        }
    }

    static void appendCurrencyValue(StringBuilder stringBuilder, String string, double d) {
        stringBuilder.append(string).append("=");
        double d2 = Math.floor(d * 1000000.0 + 0.5) / 1000000.0;
        if (d2 != 0.0) {
            stringBuilder.append(Double.toString(d2));
        }
    }

    private static String constructTransactionRequestPath(Event event, Referrer referrer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.8.1ma");
        stringBuilder.append("&utmn=").append(event.getRandomVal());
        stringBuilder.append("&utmt=tran");
        Transaction transaction = event.getTransaction();
        if (transaction != null) {
            HitBuilder.appendStringValue(stringBuilder, "&utmtid", transaction.getOrderId());
            HitBuilder.appendStringValue(stringBuilder, "&utmtst", transaction.getStoreName());
            HitBuilder.appendCurrencyValue(stringBuilder, "&utmtto", transaction.getTotalCost());
            HitBuilder.appendCurrencyValue(stringBuilder, "&utmttx", transaction.getTotalTax());
            HitBuilder.appendCurrencyValue(stringBuilder, "&utmtsp", transaction.getShippingCost());
            HitBuilder.appendStringValue(stringBuilder, "&utmtci", "");
            HitBuilder.appendStringValue(stringBuilder, "&utmtrg", "");
            HitBuilder.appendStringValue(stringBuilder, "&utmtco", "");
        }
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(HitBuilder.getEscapedCookieString(event, referrer));
        return stringBuilder.toString();
    }

    private static String constructItemRequestPath(Event event, Referrer referrer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GOOGLE_ANALYTICS_GIF_PATH);
        stringBuilder.append("?utmwv=4.8.1ma");
        stringBuilder.append("&utmn=").append(event.getRandomVal());
        stringBuilder.append("&utmt=item");
        Item item = event.getItem();
        if (item != null) {
            HitBuilder.appendStringValue(stringBuilder, "&utmtid", item.getOrderId());
            HitBuilder.appendStringValue(stringBuilder, "&utmipc", item.getItemSKU());
            HitBuilder.appendStringValue(stringBuilder, "&utmipn", item.getItemName());
            HitBuilder.appendStringValue(stringBuilder, "&utmiva", item.getItemCategory());
            HitBuilder.appendCurrencyValue(stringBuilder, "&utmipr", item.getItemPrice());
            stringBuilder.append("&utmiqt=");
            if (item.getItemCount() != 0L) {
                stringBuilder.append(item.getItemCount());
            }
        }
        stringBuilder.append("&utmac=").append(event.accountId);
        stringBuilder.append("&utmcc=").append(HitBuilder.getEscapedCookieString(event, referrer));
        return stringBuilder.toString();
    }

    public static String constructHitRequestPath(Event event, Referrer referrer) {
        StringBuilder stringBuilder = new StringBuilder();
        if ("__##GOOGLEPAGEVIEW##__".equals(event.category)) {
            stringBuilder.append(HitBuilder.constructPageviewRequestPath(event, referrer));
        } else if ("__##GOOGLEITEM##__".equals(event.category)) {
            stringBuilder.append(HitBuilder.constructItemRequestPath(event, referrer));
        } else if ("__##GOOGLETRANSACTION##__".equals(event.category)) {
            stringBuilder.append(HitBuilder.constructTransactionRequestPath(event, referrer));
        } else {
            stringBuilder.append(HitBuilder.constructEventRequestPath(event, referrer));
        }
        if (event.getAnonymizeIp()) {
            stringBuilder.append("&aip=1");
        }
        if (!event.getUseServerTime()) {
            stringBuilder.append("&utmht=" + System.currentTimeMillis());
        }
        return stringBuilder.toString();
    }

    public static String getCustomVariableParams(Event event) {
        StringBuilder stringBuilder = new StringBuilder();
        CustomVariableBuffer customVariableBuffer = event.getCustomVariableBuffer();
        if (customVariableBuffer == null) {
            return "";
        }
        if (!customVariableBuffer.hasCustomVariables()) {
            return "";
        }
        CustomVariable[] customVariableArray = customVariableBuffer.getCustomVariableArray();
        HitBuilder.createX10Project(customVariableArray, stringBuilder, 8);
        HitBuilder.createX10Project(customVariableArray, stringBuilder, 9);
        HitBuilder.createX10Project(customVariableArray, stringBuilder, 11);
        return stringBuilder.toString();
    }

    private static void createX10Project(CustomVariable[] customVariableArray, StringBuilder stringBuilder, int n) {
        boolean bl = true;
        stringBuilder.append(n).append("(");
        block5: for (int i = 0; i < customVariableArray.length; ++i) {
            if (customVariableArray[i] == null) continue;
            CustomVariable customVariable = customVariableArray[i];
            if (!bl) {
                stringBuilder.append("*");
            } else {
                bl = false;
            }
            stringBuilder.append(customVariable.getIndex()).append("!");
            switch (n) {
                case 8: {
                    stringBuilder.append(HitBuilder.x10Escape(HitBuilder.encode(customVariable.getName())));
                    continue block5;
                }
                case 9: {
                    stringBuilder.append(HitBuilder.x10Escape(HitBuilder.encode(customVariable.getValue())));
                    continue block5;
                }
                case 11: {
                    stringBuilder.append(customVariable.getScope());
                }
            }
        }
        stringBuilder.append(")");
    }

    private static String x10Escape(String string) {
        return string.replace("'", "'0").replace(")", "'1").replace("*", "'2").replace("!", "'3");
    }

    public static String getEscapedCookieString(Event event, Referrer referrer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("__utma=");
        stringBuilder.append(FAKE_DOMAIN_HASH).append(".");
        stringBuilder.append(event.getUserId()).append(".");
        stringBuilder.append(event.getTimestampFirst()).append(".");
        stringBuilder.append(event.getTimestampPrevious()).append(".");
        stringBuilder.append(event.getTimestampCurrent()).append(".");
        stringBuilder.append(event.getVisits()).append(";");
        if (referrer != null) {
            stringBuilder.append("+__utmz=");
            stringBuilder.append(FAKE_DOMAIN_HASH).append(".");
            stringBuilder.append(referrer.getTimeStamp()).append(".");
            stringBuilder.append(Integer.valueOf(referrer.getVisit()).toString()).append(".");
            stringBuilder.append(Integer.valueOf(referrer.getIndex()).toString()).append(".");
            stringBuilder.append(referrer.getReferrerString()).append(";");
        }
        return HitBuilder.encode(stringBuilder.toString());
    }

    private static String encode(String string) {
        return AnalyticsParameterEncoder.encode(string);
    }
}

