/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.google.android.apps.analytics.Dispatcher;
import com.google.android.apps.analytics.GoogleAnalyticsTracker;
import com.google.android.apps.analytics.Hit;
import com.google.android.apps.analytics.HitStore;
import com.google.android.apps.analytics.PipelinedRequester;
import com.google.android.apps.analytics.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.ParseException;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class NetworkDispatcher
implements Dispatcher {
    private static final String GOOGLE_ANALYTICS_HOST_NAME = "www.google-analytics.com";
    private static final int GOOGLE_ANALYTICS_HOST_PORT = 80;
    private static final int MAX_GET_LENGTH = 2036;
    private static final int MAX_POST_LENGTH = 8192;
    private static final String USER_AGENT_TEMPLATE = "%s/%s (Linux; U; Android %s; %s-%s; %s Build/%s)";
    private final String userAgent;
    private static final int MAX_EVENTS_PER_PIPELINE = 30;
    private static final int MAX_SEQUENTIAL_REQUESTS = 5;
    private static final long MIN_RETRY_INTERVAL = 2L;
    private final HttpHost googleAnalyticsHost;
    private DispatcherThread dispatcherThread;
    private boolean dryRun = false;

    public NetworkDispatcher() {
        this("GoogleAnalytics", "1.4.2");
    }

    public NetworkDispatcher(String string, String string2) {
        this(string, string2, GOOGLE_ANALYTICS_HOST_NAME, 80);
    }

    NetworkDispatcher(String string, String string2, String string3, int n) {
        this.googleAnalyticsHost = new HttpHost(string3, n);
        Locale locale = Locale.getDefault();
        this.userAgent = String.format(USER_AGENT_TEMPLATE, string, string2, Build.VERSION.RELEASE, locale.getLanguage() != null ? locale.getLanguage().toLowerCase() : "en", locale.getCountry() != null ? locale.getCountry().toLowerCase() : "", Build.MODEL, Build.ID);
    }

    public void init(Dispatcher.Callbacks callbacks) {
        this.stop();
        this.dispatcherThread = new DispatcherThread(callbacks, this.userAgent, this);
        this.dispatcherThread.start();
    }

    public void init(Dispatcher.Callbacks callbacks, PipelinedRequester pipelinedRequester, HitStore hitStore) {
        this.stop();
        this.dispatcherThread = new DispatcherThread(callbacks, pipelinedRequester, this.userAgent, this);
        this.dispatcherThread.start();
    }

    public void dispatchHits(Hit[] hitArray) {
        if (this.dispatcherThread == null) {
            return;
        }
        this.dispatcherThread.dispatchHits(hitArray);
    }

    public void setDryRun(boolean bl) {
        this.dryRun = bl;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    void waitForThreadLooper() {
        this.dispatcherThread.getLooper();
        while (this.dispatcherThread.handlerExecuteOnDispatcherThread == null) {
            Thread.yield();
        }
    }

    public void stop() {
        if (this.dispatcherThread != null && this.dispatcherThread.getLooper() != null) {
            this.dispatcherThread.getLooper().quit();
            this.dispatcherThread = null;
        }
    }

    String getUserAgent() {
        return this.userAgent;
    }

    private static class DispatcherThread
    extends HandlerThread {
        volatile Handler handlerExecuteOnDispatcherThread;
        private final PipelinedRequester pipelinedRequester;
        private final String userAgent;
        private int lastStatusCode;
        private int maxEventsPerRequest = 30;
        private long retryInterval;
        private AsyncDispatchTask currentTask = null;
        private final Dispatcher.Callbacks callbacks;
        private final RequesterCallbacks requesterCallBacks;
        private final NetworkDispatcher parent;

        private DispatcherThread(Dispatcher.Callbacks callbacks, String string, NetworkDispatcher networkDispatcher) {
            this(callbacks, new PipelinedRequester(networkDispatcher.googleAnalyticsHost), string, networkDispatcher);
        }

        private DispatcherThread(Dispatcher.Callbacks callbacks, PipelinedRequester pipelinedRequester, String string, NetworkDispatcher networkDispatcher) {
            super("DispatcherThread");
            this.callbacks = callbacks;
            this.userAgent = string;
            this.pipelinedRequester = pipelinedRequester;
            this.requesterCallBacks = new RequesterCallbacks();
            this.pipelinedRequester.installCallbacks(this.requesterCallBacks);
            this.parent = networkDispatcher;
        }

        protected void onLooperPrepared() {
            this.handlerExecuteOnDispatcherThread = new Handler();
        }

        public void dispatchHits(Hit[] hitArray) {
            if (this.handlerExecuteOnDispatcherThread == null) {
                return;
            }
            this.handlerExecuteOnDispatcherThread.post((Runnable)new AsyncDispatchTask(hitArray));
        }

        private class RequesterCallbacks
        implements PipelinedRequester.Callbacks {
            private RequesterCallbacks() {
            }

            public void pipelineModeChanged(boolean bl) {
                if (bl) {
                    DispatcherThread.this.maxEventsPerRequest = 30;
                } else {
                    DispatcherThread.this.maxEventsPerRequest = 1;
                }
            }

            public void requestSent() {
                if (DispatcherThread.this.currentTask == null) {
                    return;
                }
                Hit hit = DispatcherThread.this.currentTask.removeNextHit();
                if (hit != null) {
                    DispatcherThread.this.callbacks.hitDispatched(hit.hitId);
                }
            }

            public void serverError(int n) {
                DispatcherThread.this.lastStatusCode = n;
            }
        }

        private class AsyncDispatchTask
        implements Runnable {
            private final LinkedList<Hit> hits = new LinkedList();

            public AsyncDispatchTask(Hit[] hitArray) {
                Collections.addAll(this.hits, hitArray);
            }

            public void run() {
                DispatcherThread.this.currentTask = this;
                for (int i = 0; i < 5 && this.hits.size() > 0; ++i) {
                    try {
                        long l = 0L;
                        if (DispatcherThread.this.lastStatusCode == 500 || DispatcherThread.this.lastStatusCode == 503) {
                            l = (long)(Math.random() * (double)DispatcherThread.this.retryInterval);
                            if (DispatcherThread.this.retryInterval < 256L) {
                                DispatcherThread.this.retryInterval *= 2L;
                            }
                        } else {
                            DispatcherThread.this.retryInterval = 2L;
                        }
                        Thread.sleep(l * 1000L);
                        this.dispatchSomePendingHits(DispatcherThread.this.parent.isDryRun());
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)"Couldn't sleep.", (Throwable)interruptedException);
                        break;
                    }
                    catch (IOException iOException) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)"Problem with socket or streams.", (Throwable)iOException);
                        break;
                    }
                    catch (HttpException httpException) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)"Problem with http streams.", (Throwable)httpException);
                        break;
                    }
                }
                DispatcherThread.this.pipelinedRequester.finishedCurrentRequests();
                DispatcherThread.this.callbacks.dispatchFinished();
                DispatcherThread.this.currentTask = null;
            }

            private void dispatchSomePendingHits(boolean bl) throws IOException, ParseException, HttpException {
                if (GoogleAnalyticsTracker.getInstance().getDebug() && bl) {
                    Log.v((String)"GoogleAnalyticsTracker", (String)"dispatching hits in dry run mode");
                }
                for (int i = 0; i < this.hits.size() && i < DispatcherThread.this.maxEventsPerRequest; ++i) {
                    BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest;
                    String string;
                    String string2;
                    Hit hit = this.hits.get(i);
                    String string3 = Utils.addQueueTimeParameter(hit.hitString, System.currentTimeMillis());
                    int n = string3.indexOf(63);
                    if (n < 0) {
                        string2 = string3;
                        string = "";
                    } else {
                        string2 = n > 0 ? string3.substring(0, n) : "";
                        string = n < string3.length() - 2 ? string3.substring(n + 1) : "";
                    }
                    if (string.length() < 2036) {
                        basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("GET", string3);
                    } else {
                        basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("POST", "/p" + string2);
                        basicHttpEntityEnclosingRequest.addHeader("Content-Length", Integer.toString(string.length()));
                        basicHttpEntityEnclosingRequest.addHeader("Content-Type", "text/plain");
                        basicHttpEntityEnclosingRequest.setEntity((HttpEntity)new StringEntity(string));
                    }
                    String string4 = DispatcherThread.this.parent.googleAnalyticsHost.getHostName();
                    if (DispatcherThread.this.parent.googleAnalyticsHost.getPort() != 80) {
                        string4 = string4 + ":" + DispatcherThread.this.parent.googleAnalyticsHost.getPort();
                    }
                    basicHttpEntityEnclosingRequest.addHeader("Host", string4);
                    basicHttpEntityEnclosingRequest.addHeader("User-Agent", DispatcherThread.this.userAgent);
                    if (GoogleAnalyticsTracker.getInstance().getDebug()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (Header header : basicHttpEntityEnclosingRequest.getAllHeaders()) {
                            stringBuffer.append(header.toString()).append("\n");
                        }
                        stringBuffer.append(basicHttpEntityEnclosingRequest.getRequestLine().toString()).append("\n");
                        Log.i((String)"GoogleAnalyticsTracker", (String)stringBuffer.toString());
                    }
                    if (string.length() > 8192) {
                        Log.w((String)"GoogleAnalyticsTracker", (String)"Hit too long (> 8192 bytes)--not sent");
                        DispatcherThread.this.requesterCallBacks.requestSent();
                        continue;
                    }
                    if (bl) {
                        DispatcherThread.this.requesterCallBacks.requestSent();
                        continue;
                    }
                    DispatcherThread.this.pipelinedRequester.addRequest((HttpEntityEnclosingRequest)basicHttpEntityEnclosingRequest);
                }
                if (!bl) {
                    DispatcherThread.this.pipelinedRequester.sendRequests();
                }
            }

            public Hit removeNextHit() {
                return this.hits.poll();
            }
        }
    }
}

