/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

public class Item {
    private final String orderId;
    private final String itemSKU;
    private final String itemName;
    private final String itemCategory;
    private final double itemPrice;
    private final long itemCount;

    private Item(Builder builder) {
        this.orderId = builder.orderId;
        this.itemSKU = builder.itemSKU;
        this.itemPrice = builder.itemPrice;
        this.itemCount = builder.itemCount;
        this.itemName = builder.itemName;
        this.itemCategory = builder.itemCategory;
    }

    String getOrderId() {
        return this.orderId;
    }

    String getItemSKU() {
        return this.itemSKU;
    }

    String getItemName() {
        return this.itemName;
    }

    String getItemCategory() {
        return this.itemCategory;
    }

    double getItemPrice() {
        return this.itemPrice;
    }

    long getItemCount() {
        return this.itemCount;
    }

    public static class Builder {
        private final String orderId;
        private final String itemSKU;
        private final double itemPrice;
        private final long itemCount;
        private String itemName = null;
        private String itemCategory = null;

        public Builder(String string, String string2, double d, long l) {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("orderId must not be empty or null");
            }
            if (string2 == null || string2.trim().length() == 0) {
                throw new IllegalArgumentException("itemSKU must not be empty or null");
            }
            this.orderId = string;
            this.itemSKU = string2;
            this.itemPrice = d;
            this.itemCount = l;
        }

        public Builder setItemName(String string) {
            this.itemName = string;
            return this;
        }

        public Builder setItemCategory(String string) {
            this.itemCategory = string;
            return this;
        }

        public Item build() {
            return new Item(this);
        }
    }
}

