/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import com.google.android.apps.analytics.CustomVariable;

class CustomVariableBuffer {
    private CustomVariable[] customVariables = new CustomVariable[5];

    public boolean isIndexAvailable(int n) {
        this.throwOnInvalidIndex(n);
        return this.customVariables[n - 1] == null;
    }

    public void setCustomVariable(CustomVariable customVariable) {
        int n = customVariable.getIndex();
        this.throwOnInvalidIndex(n);
        this.customVariables[customVariable.getIndex() - 1] = customVariable;
    }

    public CustomVariable getCustomVariableAt(int n) {
        this.throwOnInvalidIndex(n);
        return this.customVariables[n - 1];
    }

    public CustomVariable[] getCustomVariableArray() {
        return (CustomVariable[])this.customVariables.clone();
    }

    private void throwOnInvalidIndex(int n) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException("Index must be between 1 and 5 inclusive.");
        }
    }

    public boolean hasCustomVariables() {
        for (int i = 0; i < this.customVariables.length; ++i) {
            if (this.customVariables[i] == null) continue;
            return true;
        }
        return false;
    }

    public void clearCustomVariableAt(int n) {
        this.throwOnInvalidIndex(n);
        this.customVariables[n - 1] = null;
    }
}

