/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import com.google.android.apps.analytics.AnalyticsParameterEncoder;

class CustomVariable {
    public static final int MAX_CUSTOM_VARIABLES = 5;
    public static final String INDEX_ERROR_MSG = "Index must be between 1 and 5 inclusive.";
    public static final int VISITOR_SCOPE = 1;
    public static final int SESSION_SCOPE = 2;
    public static final int PAGE_SCOPE = 3;
    public static final int MAX_CUSTOM_VARIABLE_LENGTH = 64;
    private final int scope;
    private final String name;
    private final String value;
    private final int index;

    public CustomVariable(int n, String string, String string2, int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Invalid Scope:" + n2);
        }
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException(INDEX_ERROR_MSG);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid argument for name:  Cannot be empty");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Invalid argument for value:  Cannot be empty");
        }
        int n3 = 0;
        n3 = AnalyticsParameterEncoder.encode(string + string2).length();
        if (n3 > 64) {
            throw new IllegalArgumentException("Encoded form of name and value must not exceed 64 characters combined.  Character length: " + n3);
        }
        this.index = n;
        this.scope = n2;
        this.name = string;
        this.value = string2;
    }

    public CustomVariable(int n, String string, String string2) {
        this(n, string, string2, 3);
    }

    public int getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }
}

