package com.hfad.wic;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
// import android.util.Log; // Używane w wersji z dziennikiem
// import android.os.Handler; // Używane w wersji z tostem
// import android.widget.Toast; // Używane w wersji z tostem

public class DelayedMessageService extends IntentService {

    public static final String EXTRA_MESSAGE = "message";
    // private Handler handler; // Używane w wersji z tostem
    public static final int NOTIFICATION_ID = 5453;

    public DelayedMessageService() {
        super("DelayedMessageService");
    }

    // @Override // Metoda używana w wersji z tostem
    // public int onStartCommand(Intent intent, int flags, int startId) {
    //     handler = new Handler();
    //     return super.onStartCommand(intent, flags, startId);
    // }

    @Override
    protected void onHandleIntent(Intent intent) {
        synchronized (this) {
            try {
                wait(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String text = intent.getStringExtra(EXTRA_MESSAGE);
        showText(text);
    }

    private void showText(final String text) {
        // Log.v("DelayedMessageService", "To jest komunikat: " + text); // Używane w wersji korzystającej z dziennika
        // handler.post(new Runnable() { // Wywołanie używane w wersji z tostem
        //         @Override
        //         public void run() {
        //             Toast.makeText(getApplicationContext(), text, Toast.LENGTH_LONG).show();
        //         }
        //     });
        Intent intent = new Intent(this, MainActivity.class);
        TaskStackBuilder stackBuilder = TaskStackBuilder.create(this);
        stackBuilder.addParentStack(MainActivity.class);
        stackBuilder.addNextIntent(intent);
        PendingIntent pendingIntent =
                stackBuilder.getPendingIntent(0, PendingIntent.FLAG_UPDATE_CURRENT);
        Notification notification = new Notification.Builder(this)
                .setSmallIcon(R.mipmap.ic_launcher)
                .setContentTitle(getString(R.string.app_name))
                .setAutoCancel(true)
                .setPriority(Notification.PRIORITY_MAX)
                .setDefaults(Notification.DEFAULT_VIBRATE)
                .setContentIntent(pendingIntent)
                .setContentText(text)
                .build();
        NotificationManager notificationManager =
                (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.notify(NOTIFICATION_ID, notification);
    }
}
