package com.hfad.doradcapiwny;

import android.app.Activity;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Spinner;
import android.widget.TextView;

import java.util.List;

public class FindBeerActivity extends Activity {
    private BeerExpert expert = new BeerExpert();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_find_beer);
    }

    // Metoda wywoływana, gdy użytkownik kliknie przycisk
    public void onClickFindBeer( View view) {
        // Pobiera referencję komponentu TextView
        TextView brands = (TextView)  findViewById (R.id.brands);
        // Pobiera referencję komponentu Spinner
        Spinner color = (Spinner) findViewById(R.id.color);
        // Pobiera wartość wybraną w komponencie Spinner
        String beerType = String.valueOf(color. getSelectedItem() );
        // Pobranie rekomendacji z klasy BeerExpert
        List<String> brandsList = expert.getBrands(beerType);
        StringBuilder brandsFormatted = new StringBuilder();
        for (String brand : brandsList) {
            brandsFormatted.append(brand).append('\n');
        }
        // Wyświetla wybraną wartość
        brands.setText(brandsFormatted);
    }
}
