#!/usr/bin/env python

import sys

from scapy.packet import Raw, fuzz
from USBFuzz.MSC import *

arg = sys.argv[1].split(':')
dev = BOMSDevice(arg[0], arg[1], timeout=1200)

# upewnij sie czy potok jest pusty
dev.boms_reset()

# Odczytaj pojemnosc aby otrzymac rozmiar bloku
cmd = MSCCBW()/SCSICmd()/ReadCapacity10()
#cmd.show2()
#print dev.hex_dump(str(cmd))
dev.send(cmd)
reply = dev.read_reply()
dev.check_status(reply) 
if Raw in reply and len(reply[Raw]) == 8:
    data = str(reply[Raw])
    max_lba = struct.unpack(">I", data[:4])[0]
    block_size = struct.unpack(">I", data[4:])[0]
else:
    reply.show()
    sys.exit()

print "Urzadzenie ma %uMb, max LBA to %x a blocksize to %x" % (round(float(max_lba*block_size)/1048576), max_lba, block_size)

opcode = 0x95
while dev is not None:
    try:
        opcode += 1        
        test = 0
        while test<100:
            test += 1

            r = struct.unpack("I", os.urandom(4))[0]
            print "\nWysylanie polecenia %u z losowa wartoscia %x" % (dev.cur_tag() + 1, r)
            cmd = MSCCBW(ReqTag=dev.next_tag(), ExpectedDataSize=r)/SCSICmd(OperationCode=opcode)/Raw(os.urandom(r%20))
            #cmd.show2()
            print dev.hex_dump(str(cmd))

            # wykonaj test
            try:
                dev.send(cmd)
                reply = dev.read_reply()
            except USBException as e:
                print "Wyjatek: %s podczas wykonywania polecenia %u" % (e, dev.cur_tag())
                dev.reset()

            # wyswietl dane odpowiedzi
            if Raw in reply and len(reply)>0:
                print dev.hex_dump(str(reply[Raw]))

            # sprawdz CSW
            ok = dev.check_status(reply)
            if len(reply) == 0:
                print "Brak odpowiedzi na polecenie %u!" % dev.cur_tag()

            # monitorowanie celu
            if test%10==0:
                 if not dev.is_alive():
                    print "Urzadzenie nie odpowiada, resetowanie!"
                    dev.reset()

    except USBException as e:
        print "Wyjatek: %s w petli polecen, resetowanie!" % e
        dev.reset()

