package pl.twojadomena.rozdzial_9_b;

import java.io.InputStream;
import java.net.URL;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;

public class MainActivity extends Activity 
{
//	private String adres = "http://www.heavens-above.com/orbitdisplay.aspx?icon=iss&width=300&height=300&satid=25544"; 
//	private String adres = "http://api.usno.navy.mil/imagery/moon.png";
	private String adres = "http://sdo.gsfc.nasa.gov/assets/img/latest/latest_512_4500.jpg";
	private Button przycisk;
	private ImageView obraz;
	private ProgressBar stan;
	private TextView napis; 
	private Bitmap bmp;

    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        przycisk = (Button) findViewById(R.id.button1);
        obraz = (ImageView) findViewById(R.id.imageView1);
        napis = (TextView) findViewById(R.id.textView1);
        stan = (ProgressBar) findViewById(R.id.progressBar1);
    }
    public void kliknieto_sciagaj( View v)
    {
    	OdczytObrazka oo = new OdczytObrazka();
    	oo.execute();
    } 
//------------------------------------------------------------------------------
    class OdczytObrazka extends AsyncTask<Void, Void, Void>
    {
    	boolean sukces=true;
    	@Override
    	protected Void doInBackground( Void... arg0) 
    	{
    		URL u;
    		InputStream is;
    		try
    		{
    			u = new URL( adres);
    			is = u.openStream();
    			Bitmap temp = BitmapFactory.decodeStream(is);
    	        bmp=temp.copy(Bitmap.Config.ARGB_8888, true);
    		}
    		catch( Exception e)
    		{
    			sukces = false;
    		}
    		
    		// TODO Auto-generated method stub
    		return null;
    	}
    	@Override
    	protected void onPreExecute() 
    	{
			stan.setVisibility( ProgressBar.VISIBLE);
			przycisk.setEnabled(false);
			napis.setText( "Pobieranie danych ...");
    		// TODO Auto-generated method stub
    		super.onPreExecute();
    	}
    	@Override
    	protected void onPostExecute(Void result) 
    	{
			if( sukces)
			{
				Canvas c = new Canvas( bmp);
				Paint p = new Paint();
		    	int szer = bmp.getWidth(), wys = bmp.getHeight();
		    	p.setColor(Color.WHITE);
		    	p.setStyle(Paint.Style.STROKE);
		    	c.drawRect(0, 0, szer-1, wys-1, p);

		    	obraz.setImageBitmap( bmp);
				napis.setText( "Pobieranie danych zakoczone. Obraz " + szer + " x " + wys);
			}
			else
			{
				napis.setText( "Bd podczas pobierania danych.");
			}
			przycisk.setEnabled(true);
			stan.setVisibility( ProgressBar.INVISIBLE);
			
    		// TODO Auto-generated method stub
    		super.onPostExecute(result);
    	}
    }
}
