package com.gameproject.alltogether;



import java.util.concurrent.ArrayBlockingQueue;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;


public class GameView extends SurfaceView implements
		SurfaceHolder.Callback {

	private SpriteObject sprite;
	private SpriteObject[] bomb;

	
	private GameLogic mGameLogic;
	private ArrayBlockingQueue<InputObject> inputObjectPool;
	
	private int sound_id;
	private Context context;
	private SoundPool soundPool;
	private int ID_robot_noise;
	private int ID_alien_noise;
	private int ID_human_noise;
	private MediaPlayer mp;
	
	public GameView(Context con) {
		super(con);
		context = con;
		getHolder().addCallback(this);
		sprite = new SpriteObject(BitmapFactory.decodeResource(getResources(), R.drawable.sprite), 100, 400);
		bomb = new SpriteObject[3];
		bomb[0] = new SpriteObject(BitmapFactory.decodeResource(getResources(), R.drawable.bomb), 400, 500);
		bomb[1] = new SpriteObject(BitmapFactory.decodeResource(getResources(), R.drawable.bomb), 650, 100);
		bomb[2] = new SpriteObject(BitmapFactory.decodeResource(getResources(), R.drawable.bomb), 900, 500);
		mGameLogic = new GameLogic(getHolder(), this);
		createInputObjectPool();
		

		soundPool = new SoundPool(10, AudioManager.STREAM_MUSIC, 0);
		
		ID_robot_noise = soundPool.load(context, R.raw.robot_noise, 1);
    	ID_alien_noise = soundPool.load(context, R.raw.alien_noise, 2);
    	ID_human_noise = soundPool.load(context, R.raw.human_noise, 3);
		
		sound_id = ID_robot_noise;
		

		
		setFocusable(true);
	}

	private void createInputObjectPool() {
		inputObjectPool = new ArrayBlockingQueue<InputObject>(20);
		for (int i = 0; i < 20; i++) {
			inputObjectPool.add(new InputObject(inputObjectPool));
		}
	}

	

		@Override
		public boolean onTouchEvent(MotionEvent event) {
			try {
				int hist = event.getHistorySize();
				if (hist > 0) {
					for (int i = 0; i < hist; i++) {
						InputObject input = inputObjectPool.take();
						input.useEventHistory(event, i);
						mGameLogic.feedInput(input);
					}
				}
				InputObject input = inputObjectPool.take();
				input.useEvent(event);
				mGameLogic.feedInput(input);
			} catch (InterruptedException e) {
			}
			try {
				Thread.sleep(16);
			} catch (InterruptedException e) {
			}
			return true;
		}
		
		
	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width,
			int height) {
	}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		mGameLogic.setGameState(mGameLogic.RUNNING);
		mGameLogic.start();
		bomb[0].setMoveY(-.5);
		bomb[1].setMoveY(.5);
		bomb[2].setMoveY(-.5);
		MediaPlayer mp = MediaPlayer.create(context, R.raw.background_music);
		mp.setLooping(true);
		mp.start();
		Log.d("music","GRAM MUZYKE");
	}
	
	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		soundPool.release();
		mp.stop();
		mp.release();
	}
	
	
	@Override
	public void onDraw(Canvas canvas) {
		canvas.drawColor(Color.GRAY);
		sprite.draw(canvas);
		for(int i = 0; i < 3; i++){
			bomb[i].draw(canvas);
		}
	}

	public void update(int adj_mov) {
		
		//sprawdzenie, czy bomby nie znajduj si zbyt nisko
		for(int i = 0; i < 3; i++){
			if(bomb[i].getY() > 500){
				bomb[i].setMoveY(-.5);
			}
		}
		
		//sprawdzenie, czy bomby nie znajduj si zbyt wysoko
		for(int i = 0; i < 3; i++){
			if(bomb[i].getY() < 100){
				bomb[i].setMoveY(.5);
			}
		}
		
		//sprawdzenie kolizji sprajta
		for(int i = 0; i < 3; i++){
			if(sprite.collide(bomb[i])){
				sprite.setX(100);
			}
		}
		
		if(sprite.getstate() == sprite.DEAD){
			sprite.setX(0);
			sprite.setY(0);
		}
		
		//wykonanie odpowiednich akcji 
		for(int i = 0; i < 3; i++){
			bomb[i].update(adj_mov);
		}		
		sprite.update(adj_mov);

	}
	
	public void processMotionEvent(InputObject input){
		
		/*soundPool.play(sound_id,1.0f,1.0f,10,0,1f);
		sound_id++;
		if (sound_id == 3){
			sound_id = 0;
		}*/
		
		if(input.action == input.ACTION_TOUCH_DOWN){
			sprite.setMoveX(.5);
		}
		if(input.action == input.ACTION_TOUCH_UP){
			sprite.setMoveX(0);
		}
		
		
		//sprite.setX(input.x);
		//sprite.setY(input.y);
	}
	
	public void processKeyEvent(InputObject input){

	}

	public void processOrientationEvent(float orientation[]){
		
		float roll = orientation[2];
		if (roll < -40) {
			sprite.setMoveX(2);
		} else if (roll > 40) {
			sprite.setMoveX(-2);
		}
		
	}


	public void playsound(int sound_id){
		soundPool.play(sound_id, 1.0f, 1.0f, 1, 0, 1.0f);
	}
	

	
	

	
}
