package com.manning.aip.dealdroid;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

public abstract class Util {
	public static Bitmap retrieveBitmap(final String urlString) {
		Log.d(Constants.LOG_TAG, "Wywoanie HTTP w celu pobrania rysunku:" + urlString);
		Bitmap bitmap = null;
		InputStream stream = null;
		try {
			URL url = new URL(urlString);
			stream = url.openConnection().getInputStream();
			bitmap = BitmapFactory.decodeStream(stream);
		} catch (MalformedURLException e) {
			Log.e(Constants.LOG_TAG, "Wyjtek przy wczytywaniu rysunku. Bdny adres URL",
					e);
		} catch (IOException e) {
			Log.e(Constants.LOG_TAG, "Wyjtek przy wczytywaniu rysunku. Bd wejcia-wyjcia", e);
		} finally {
			try {
				if (stream != null) {
					stream.close();
				}
			} catch (IOException e) {
				Log.w(Constants.LOG_TAG, "Bd przy zamykaniu strumienia", e);
			}
		}
		return bitmap;
	}
}
