package com.manning.aip.dealdroid;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.State;
import android.util.Log;

import com.manning.aip.dealdroid.model.Item;
import com.manning.aip.dealdroid.model.Section;
import com.manning.aip.dealdroid.xml.DailyDealsFeedParser;
import com.manning.aip.dealdroid.xml.DailyDealsXmlPullFeedParser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DealDroidApp extends Application {

   private ConnectivityManager cMgr;
   private DailyDealsFeedParser parser;
   private List<Section> sectionList;
   private Map<Long, Bitmap> imageCache;
   private Item currentItem;
   
   //
   // Procedury pobierajce i ustawiajce
   //
   public DailyDealsFeedParser getParser() {
      return this.parser;
   }

   public List<Section> getSectionList() {
      return this.sectionList;
   }

   public Map<Long, Bitmap> getImageCache() {
      return this.imageCache;
   }

   public Item getCurrentItem() {
      return this.currentItem;
   }

   public void setCurrentItem(Item currentItem) {
      this.currentItem = currentItem;
   }

   //
   // Obsuga cyklu ycia
   //
   @Override
   public void onCreate() {
      super.onCreate();
      this.cMgr = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
      this.parser = new DailyDealsXmlPullFeedParser();
      this.sectionList = new ArrayList<Section>(6);
      this.imageCache = new HashMap<Long, Bitmap>();
   }

   @Override
   public void onTerminate() {
      // Brak gwarancji wywoania
      super.onTerminate();
   }

   //
   // Metody pomocnicze, uywane przez wicej ni jedn aktywno.
   // Mona je umieci take w klasie narzdziowej.
   //
   public Bitmap retrieveBitmap(String urlString) {
      Log.d(Constants.LOG_TAG, "Pobieranie rysunku:" + urlString);
      Bitmap bitmap = null;
      try {
         URL url = new URL(urlString);
         // UWAGA - nie ograniczaj si do wywoania "url.openStream()".  
         // Jest to skrcony odpowiednik wywoania openConnection().getInputStream(), ktry nie ustawia limitu czasu.
         // Warto domylna to nieskonczono, dlatego aplikacja czeka wtedy bez koca na serwer, jeli ten nie dziaa.
         // Kilka dodatkowych wierszy pozwala utworzy poprawne rozwizanie.         
         URLConnection conn = url.openConnection();     
         conn.setConnectTimeout(3000);
         conn.setReadTimeout(5000);         
         bitmap = BitmapFactory.decodeStream(conn.getInputStream());
      } catch (MalformedURLException e) {
         Log.e(Constants.LOG_TAG, "Wyjtek przy pobieraniu rysunku - bdny URL", e);
      } catch (IOException e) {
         Log.e(Constants.LOG_TAG, "Wyjtek przy pobieraniu rysunku - bd wejcia-wyjcia", e);
      } 
      return bitmap;
   }

   public boolean connectionPresent() {
      NetworkInfo netInfo = cMgr.getActiveNetworkInfo();
      if ((netInfo != null) && (netInfo.getState() != null)) {
         return netInfo.getState().equals(State.CONNECTED);
      } 
      return false;
   }
}