package com.manning.aip.brewmap;

import android.os.Bundle;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.manning.aip.brewmap.model.BrewLocation;

import java.util.List;

public class MapResults extends MapActivity {

   private MapView map;
   private List<Overlay> overlays;

   private BrewMapApp app;

   @Override
   public void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.map_results);

      app = (BrewMapApp) getApplication();

      map = (MapView) findViewById(R.id.map);
      map.setBuiltInZoomControls(true);

      List<BrewLocation> brewLocations = app.getBrewLocations();
      BrewLocationOverlay brewLocationOverlay = new BrewLocationOverlay(this, brewLocations, this.getResources().getDrawable(R.drawable.beer_icon_small));
      overlays = map.getOverlays();
      overlays.add(brewLocationOverlay);

      // DO ZROBIENIA: precyzyjne ustalanie rodka zbioru wsprzdnych. Obecna wersja
      // jest leniwa - uywany jest pierwszy punkt ze zbioru
      map.getController().setCenter(
               new GeoPoint((int) (brewLocations.get(0).getLatitude() * 1e6), (int) (brewLocations.get(0).getLongitude() * 1e6)));

      // Przyblianie zaznaczenia (bez koniecznoci rcznego wyznaczania prostokta;
      // dobry Android ;))      
      map.getController().zoomToSpan(brewLocationOverlay.getLatSpanE6(), brewLocationOverlay.getLonSpanE6());
   }

   @Override
   protected boolean isRouteDisplayed() {
      // DO ZROBIENIA: automatycznie wygenerowana namiastka
      return false;
   }
}