/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionList
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ExecutionList.class.getName());
    private final List<RunnableExecutorPair> runnables = Lists.newArrayList();
    private boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        boolean executeImmediate = false;
        List<RunnableExecutorPair> list = this.runnables;
        synchronized (list) {
            if (!this.executed) {
                this.runnables.add(new RunnableExecutorPair(runnable, executor));
            } else {
                executeImmediate = true;
            }
        }
        if (executeImmediate) {
            executor.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        List<RunnableExecutorPair> list = this.runnables;
        synchronized (list) {
            this.executed = true;
        }
        for (RunnableExecutorPair runnableAndExecutor : this.runnables) {
            runnableAndExecutor.execute();
        }
    }

    private static class RunnableExecutorPair {
        final Runnable runnable;
        final Executor executor;

        RunnableExecutorPair(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        void execute() {
            try {
                this.executor.execute(this.runnable);
            }
            catch (RuntimeException e) {
                LOG.log(Level.SEVERE, "RuntimeException while executing runnable " + this.runnable + " with executor " + this.executor, e);
            }
        }
    }
}

