/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Instrumentation;
import android.util.Log;
import android.widget.TextView;
import com.jayway.android.robotium.solo.MatchCounter;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Searcher {
    private final ViewFetcher viewFetcher;
    private final Scroller scroller;
    private final Instrumentation inst;
    private final Sleeper sleeper;
    private final int TIMEOUT = 5000;
    private final String LOG_TAG = "Robotium";

    public Searcher(ViewFetcher viewFetcher, Scroller scroller, Instrumentation inst, Sleeper sleeper) {
        this.viewFetcher = viewFetcher;
        this.scroller = scroller;
        this.inst = inst;
        this.sleeper = sleeper;
    }

    public boolean searchWithTimeoutFor(Class<? extends TextView> viewClass, String regex, int expectedMinimumNumberOfMatches, boolean scroll, boolean onlyVisible) {
        long endTime = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < endTime) {
            this.sleeper.sleep();
            boolean foundAnyMatchingView = this.searchFor(viewClass, regex, expectedMinimumNumberOfMatches, scroll, onlyVisible);
            if (!foundAnyMatchingView) continue;
            return true;
        }
        return false;
    }

    public <T extends TextView> boolean searchFor(final Class<T> viewClass, String regex, int expectedMinimumNumberOfMatches, boolean scroll, final boolean onlyVisible) {
        Callable viewFetcherCallback = new Callable<Collection<T>>(){

            @Override
            public Collection<T> call() throws Exception {
                Searcher.this.sleeper.sleep();
                Searcher.this.inst.waitForIdleSync();
                if (onlyVisible) {
                    return RobotiumUtils.removeInvisibleViews(Searcher.this.viewFetcher.getCurrentViews(viewClass));
                }
                return Searcher.this.viewFetcher.getCurrentViews(viewClass);
            }
        };
        try {
            return this.searchFor(viewFetcherCallback, regex, expectedMinimumNumberOfMatches, scroll);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends TextView> boolean searchFor(Callable<Collection<T>> viewFetcherCallback, String regex, int expectedMinimumNumberOfMatches, boolean scroll) throws Exception {
        if (expectedMinimumNumberOfMatches < 1) {
            expectedMinimumNumberOfMatches = 1;
        }
        Pattern pattern = Pattern.compile(regex);
        while (true) {
            Collection<T> views = viewFetcherCallback.call();
            for (TextView view : views) {
                Matcher matcher = pattern.matcher(((Object)view.getText()).toString());
                if (matcher.find()) {
                    MatchCounter.addMatchToCount();
                }
                if (MatchCounter.getTotalCount() != expectedMinimumNumberOfMatches) continue;
                MatchCounter.resetCount();
                return true;
            }
            if (scroll && !this.scroller.scroll(Scroller.Direction.DOWN)) {
                this.logMatchesFound(regex);
                return false;
            }
            if (!scroll) {
                this.logMatchesFound(regex);
                return false;
            }
            this.sleeper.sleep();
        }
    }

    private void logMatchesFound(String regex) {
        if (MatchCounter.getTotalCount() > 0) {
            Log.d((String)"Robotium", (String)(" There are only " + MatchCounter.getTotalCount() + " matches of " + regex));
        }
        MatchCounter.resetCount();
    }
}

