/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner;

import com.android.monkeyrunner.MonkeyRunnerOptions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.JLineConsole;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRunner {
    private static final Logger LOG = Logger.getLogger(MonkeyRunnerOptions.class.getName());
    private final Object scope;
    private final String variable;

    private ScriptRunner(Object scope, String variable) {
        this.scope = scope;
        this.variable = variable;
    }

    public static ScriptRunner newInstance(Object scope, String variable) {
        return new ScriptRunner(scope, variable);
    }

    public static int run(String executablePath, String scriptfilename, Collection<String> args, Map<String, Predicate<PythonInterpreter>> plugins) {
        File f = new File(scriptfilename);
        ArrayList classpath = Lists.newArrayList((Object[])new String[]{f.getParent()});
        classpath.addAll(plugins.keySet());
        String[] argv = new String[args.size() + 1];
        argv[0] = f.getAbsolutePath();
        int x = 1;
        for (String arg : args) {
            argv[x++] = arg;
        }
        ScriptRunner.initPython(executablePath, classpath, argv);
        PythonInterpreter python = new PythonInterpreter();
        for (Map.Entry<String, Predicate<PythonInterpreter>> entry : plugins.entrySet()) {
            boolean success;
            try {
                success = entry.getValue().apply((Object)python);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Plugin Main through an exception.", e);
                continue;
            }
            if (success) continue;
            LOG.severe("Plugin Main returned error for: " + entry.getKey());
        }
        python.set("__name__", (Object)"__main__");
        python.set("__file__", (Object)scriptfilename);
        try {
            python.execfile(scriptfilename);
        }
        catch (PyException e) {
            if (Py.SystemExit.equals((Object)e.type)) {
                return (Integer)e.value.__tojava__(Integer.class);
            }
            LOG.log(Level.SEVERE, "Script terminated due to an exception", e);
            return 1;
        }
        return 0;
    }

    public static void runString(String executablePath, String script) {
        ScriptRunner.initPython(executablePath);
        PythonInterpreter python = new PythonInterpreter();
        python.exec(script);
    }

    public static Map<String, PyObject> runStringAndGet(String executablePath, String script, String ... names) {
        return ScriptRunner.runStringAndGet(executablePath, script, Arrays.asList(names));
    }

    public static Map<String, PyObject> runStringAndGet(String executablePath, String script, Collection<String> names) {
        ScriptRunner.initPython(executablePath);
        PythonInterpreter python = new PythonInterpreter();
        python.exec(script);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : names) {
            builder.put((Object)name, (Object)python.get(name));
        }
        return builder.build();
    }

    private static void initPython(String executablePath) {
        List<String> arg = Collections.emptyList();
        ScriptRunner.initPython(executablePath, arg, new String[]{""});
    }

    private static void initPython(String executablePath, Collection<String> pythonPath, String[] argv) {
        Properties props = new Properties();
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("java.class.path"));
        for (String p : pythonPath) {
            sb.append(":").append(p);
        }
        props.setProperty("python.path", sb.toString());
        props.setProperty("python.verbose", "error");
        props.setProperty("python.executable", executablePath);
        PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)props, (String[])argv);
        String frameworkDir = System.getProperty("java.ext.dirs");
        File monkeyRunnerJar = new File(frameworkDir, "monkeyrunner.jar");
        if (monkeyRunnerJar.canRead()) {
            PySystemState.packageManager.addJar(monkeyRunnerJar.getAbsolutePath(), false);
        }
    }

    public static void console(String executablePath) {
        ScriptRunner.initPython(executablePath);
        JLineConsole python = new JLineConsole();
        python.interact();
    }
}

