package com.darwinsys.tabbytext;

import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class Main extends Activity {
	private static final int REQ_GET_CONTACT = 1;
	private EditText number;

	/** Wywoywana, gdy aktywno jest tworzona po raz pierwszy */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		number = (EditText) findViewById(R.id.contactText);
		
		Button b = (Button) findViewById(R.id.contactChoose);
		b.setOnClickListener(new View.OnClickListener() {			
			@Override
			public void onClick(View arg0) {
				Uri uri = ContactsContract.Contacts.CONTENT_URI;
				System.out.println(uri);
				Intent intent = new Intent(Intent.ACTION_PICK, uri);
				startActivityForResult(intent, REQ_GET_CONTACT);
			}
		});
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		if (requestCode == REQ_GET_CONTACT) {
			switch(resultCode) {
			case Activity.RESULT_OK:
                // Interfejs API aplikacji Contacts jest trudny w uyciu.
                // Najpierw trzeba uzyska dane kontaktowe, poniewa
                // intencja zwraca tylko identyfikator URI
				Uri resultUri = data.getData(); // Na przykad content://contacts/people/123
				Cursor cont = getContentResolver().query(resultUri, null, null, null, null);
				if (!cont.moveToNext()) {	// Oczekiwany jest jeden wiersz
					Toast.makeText(this, "Brak danych w kursorze", Toast.LENGTH_LONG).show(); 
					return;
				}
				int columnIndexForId = cont.getColumnIndex(ContactsContract.Contacts._ID);
				String contactId = cont.getString(columnIndexForId);
				int columnIndexForHasPhone = cont.getColumnIndex(ContactsContract.Contacts.HAS_PHONE_NUMBER);
				boolean hasAnyPhone = Boolean.parseBoolean(cont.getString(columnIndexForHasPhone));
				if (!hasAnyPhone) {
					Toast.makeText(this, "Brak numeru telefonu w danych wybranej osoby ", Toast.LENGTH_LONG).show(); 
				}
				// Teraz trzeba przesa nastpne zapytanie, aby pobra numery
				Cursor numbers = getContentResolver().query(
						ContactsContract.CommonDataKinds.Phone.CONTENT_URI, 
						null, 
						ContactsContract.CommonDataKinds.Phone.CONTACT_ID + "=" + contactId, // "selection", 
						null, null);
				// Mona te pobiera tylko numer telefonu komrkowego
				while (numbers.moveToNext()) {
					String aNumber = numbers.getString(numbers.getColumnIndex(ContactsContract.CommonDataKinds.Phone.NUMBER));
					System.out.println(aNumber);
					number.setText(aNumber);
				}
				if (cont.moveToNext()) {
					System.out.println("UWAGA: Zwrcono dane wicej ni jednej osoby!");
				}
				numbers.close();
				cont.close();
				break;
			case Activity.RESULT_CANCELED:
				// Nie trzeba wykonywa adnych operacji
				break;
			default:
				Toast.makeText(this, "Nieoczekiwana warto resultCode: " + resultCode, Toast.LENGTH_LONG).show(); 
				break;
			}
		}
		super.onActivityResult(requestCode, resultCode, data);
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
		MenuInflater inf = getMenuInflater();
		inf.inflate(R.menu.menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.settings:
			startActivity(new Intent(this, SettingsActivity.class));
			return true;
		case R.id.about:
			startActivity(new Intent(this, AboutActivity.class));
			return true;
		}
		return false;
	}
}
