package com.examples.splashdialog;

import android.app.Activity;
import android.app.Dialog;
import android.os.Bundle;
import android.os.Handler;

/** Wywietlanie ekranu powitalnego
 * @author Ian Darwin (na podstawie wersji Iana Cliftona)
 */
public class Main extends Activity {
	private class StateSaver {
		private boolean showSplashScreen = true;
		// Tu mona zapisa take inne informacje o stanie
	}
	private static final int MAX_SPLASH_SECONDS = 10;
	private Dialog splashDialog;
	
    /** Wywoywana, gdy aktywnos tworzona jest po raz pierwszy */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        StateSaver data = (StateSaver) getLastNonConfigurationInstance();
        if (data != null) { // Operacje byy ju wykonywane,
        	if (data.showSplashScreen ) { // ale naley wywietli ekran powitalny
        		showSplashScreen();
        	}
        	setContentView(R.layout.main);
        	// Odtwarzanie interfejsu uytkownika na podstawie zapisanego stanu
        } else {
        	showSplashScreen();
        	setContentView(R.layout.main);
        	// Pobieranie danych w odrbnym wtku
        }               
    }
    
    @Override
    public Object onRetainNonConfigurationInstance() {
    	StateSaver data = new StateSaver();
    	// W tym obiekcie naley zapisa dane
    	
    	if (splashDialog != null) {
    		data.showSplashScreen = true;
    		removeSplashScreen();
    	}
    	return data;
    }

	private void removeSplashScreen() {
		if (splashDialog != null) {
			splashDialog.dismiss();
			splashDialog = null;
		}
	}

	private void showSplashScreen() {
		splashDialog = new Dialog(this);
		splashDialog.setContentView(R.layout.splashscreen);
		splashDialog.setCancelable(false);
		splashDialog.show();
		
		// Uruchamianie dziaajcego w tle obiektu Handler w celu zamknicia 
		// (dla pewnoci) okna powitalnego
		final Handler handler = new Handler();
		handler.postDelayed(new Runnable() {
			@Override
			public void run() {
				removeSplashScreen();
			}	
		}, MAX_SPLASH_SECONDS * 1000);
	}
}